"use strict";async function updateIconInCache(e,t,o){var n,c,s;try{null===(n=null==o?void 0:o.step)||void 0===n||n.call(o,`Updating icon in cache for currency ${e}`);const s=`${CACHE_KEY_PREFIX}${e}`;await redis.set(s,t,"EX",CACHE_EXPIRY);null===(c=null==o?void 0:o.success)||void 0===c||c.call(o,`Icon cached for ${e}`)}catch(e){null===(s=null==o?void 0:o.fail)||void 0===s||s.call(o,e.message);throw e}}async function getEcosystemTokensAll(e){var t,o,n;try{null===(t=null==e?void 0:e.step)||void 0===t||t.call(e,"Fetching all ecosystem tokens");const n=await db_1.models.ecosystemToken.findAll();null===(o=null==e?void 0:e.success)||void 0===o||o.call(e,`Found ${n.length} ecosystem token(s)`);return n}catch(t){null===(n=null==e?void 0:e.fail)||void 0===n||n.call(e,t.message);throw t}}async function getEcosystemTokenByChainAndCurrency(e,t,o){var n,c,s,a;try{null===(n=null==o?void 0:o.step)||void 0===n||n.call(o,`Fetching token for chain ${e} and currency ${t}`);const a=await db_1.models.ecosystemToken.findOne({where:{chain:e,currency:t}});a?null===(c=null==o?void 0:o.success)||void 0===c||c.call(o,`Token found for ${e}/${t}`):null===(s=null==o?void 0:o.step)||void 0===s||s.call(o,`No token found for ${e}/${t}`);return a}catch(e){null===(a=null==o?void 0:o.fail)||void 0===a||a.call(o,e.message);throw e}}async function getEcosystemTokenById(e,t){var o,n,c,s;try{null===(o=null==t?void 0:t.step)||void 0===o||o.call(t,`Fetching token with ID ${e}`);const s=await db_1.models.ecosystemToken.findByPk(e);s?null===(n=null==t?void 0:t.success)||void 0===n||n.call(t,`Token found with ID ${e}`):null===(c=null==t?void 0:t.step)||void 0===c||c.call(t,`No token found with ID ${e}`);return s}catch(e){null===(s=null==t?void 0:t.fail)||void 0===s||s.call(t,e.message);throw e}}async function getEcosystemTokensByChain(e){return db_1.models.ecosystemToken.findAll({where:{chain:e,network:process.env[`${e}_NETWORK`]}})}async function createEcosystemToken({chain:e,name:t,currency:o,contract:n,decimals:c,type:s,network:a},i){var l,r,m;try{null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,`Creating ecosystem token ${t} (${o}) on ${e}`);const m=await db_1.models.ecosystemToken.create({chain:e,name:t,currency:o,contract:n,decimals:c,type:s,network:a,status:!0,contractType:"PERMIT"});null===(r=null==i?void 0:i.success)||void 0===r||r.call(i,`Token ${t} created successfully`);await wallet_1.precisionCacheService.invalidateEcoToken(o,e);return m}catch(e){null===(m=null==i?void 0:i.fail)||void 0===m||m.call(i,e.message);throw e}}async function importEcosystemToken({name:e,currency:t,chain:o,network:n,type:c,contract:s,decimals:a,contractType:i},l){var r,m,u;try{null===(r=null==l?void 0:l.step)||void 0===r||r.call(l,`Importing token ${e} (${t}) on ${o}`);const u=await db_1.models.ecosystemToken.create({name:e,currency:t,chain:o,network:n,type:c,contract:s,decimals:a,status:!0,contractType:i});null===(m=null==l?void 0:l.success)||void 0===m||m.call(l,`Token ${e} imported successfully`);await wallet_1.precisionCacheService.invalidateEcoToken(t,o);return u}catch(e){null===(u=null==l?void 0:l.fail)||void 0===u||u.call(l,e.message);throw e}}async function updateAdminTokenIcon(e,t,o){var n,c,s;try{null===(n=null==o?void 0:o.step)||void 0===n||n.call(o,`Updating icon for token ID ${e}`);await db_1.models.ecosystemToken.update({icon:t},{where:{id:e}});null===(c=null==o?void 0:o.success)||void 0===c||c.call(o,`Token icon updated for ID ${e}`)}catch(e){null===(s=null==o?void 0:o.fail)||void 0===s||s.call(o,e.message);throw e}}async function getNoPermitTokens(e,t){var o,n,c;try{null===(o=null==t?void 0:t.step)||void 0===o||o.call(t,`Fetching NO_PERMIT tokens for chain ${e}`);const c=await db_1.models.ecosystemToken.findAll({where:{chain:e,contractType:"NO_PERMIT",network:process.env[`${e}_NETWORK`],status:!0}});null===(n=null==t?void 0:t.success)||void 0===n||n.call(t,`Found ${c.length} NO_PERMIT token(s) for ${e}`);return c}catch(e){null===(c=null==t?void 0:t.fail)||void 0===c||c.call(t,e.message);throw e}}async function updateStatusBulk(e,t,o){var n,c,s;try{null===(n=null==o?void 0:o.step)||void 0===n||n.call(o,`Updating status for ${e.length} token(s)`);await db_1.models.ecosystemToken.update({status:t},{where:{id:e}});null===(c=null==o?void 0:o.success)||void 0===c||c.call(o,`Status updated for ${e.length} token(s)`);await wallet_1.precisionCacheService.invalidateEcoCache()}catch(e){null===(s=null==o?void 0:o.fail)||void 0===s||s.call(o,e.message);throw e}}async function updateAdminToken(e,t,o,n,c){var s,a,i;try{null===(s=null==c?void 0:c.step)||void 0===s||s.call(c,`Updating token details for ID ${e}`);const i=await db_1.models.ecosystemToken.findByPk(e);await db_1.models.ecosystemToken.update({precision:t,limits:o,fee:n},{where:{id:e}});null===(a=null==c?void 0:c.success)||void 0===a||a.call(c,`Token details updated for ID ${e}`);i&&await wallet_1.precisionCacheService.invalidateEcoToken(i.currency,i.chain)}catch(e){null===(i=null==c?void 0:c.fail)||void 0===i||i.call(c,e.message);throw e}}Object.defineProperty(exports,"__esModule",{value:!0});exports.ecosystemTokenStoreSchema=exports.ecosystemTokenImportSchema=exports.ecosystemTokenDeploySchema=exports.ecosystemTokenUpdateSchema=exports.baseEcosystemTokenSchema=exports.ecosystemTokenSchema=void 0;exports.updateIconInCache=updateIconInCache;exports.getEcosystemTokensAll=getEcosystemTokensAll;exports.getEcosystemTokenByChainAndCurrency=getEcosystemTokenByChainAndCurrency;exports.getEcosystemTokenById=getEcosystemTokenById;exports.getEcosystemTokensByChain=getEcosystemTokensByChain;exports.createEcosystemToken=createEcosystemToken;exports.importEcosystemToken=importEcosystemToken;exports.updateAdminTokenIcon=updateAdminTokenIcon;exports.getNoPermitTokens=getNoPermitTokens;exports.updateStatusBulk=updateStatusBulk;exports.updateAdminToken=updateAdminToken;const db_1=require("@b/db"),redis_1=require("@b/utils/redis"),schema_1=require("@b/utils/schema"),wallet_1=require("@b/services/wallet"),redis=redis_1.RedisSingleton.getInstance(),CACHE_KEY_PREFIX="ecosystem_token_icon:",CACHE_EXPIRY=3600,id=(0,schema_1.baseStringSchema)("ID of the ecosystem token"),contract=(0,schema_1.baseStringSchema)("Contract address of the token"),name=(0,schema_1.baseStringSchema)("Name of the token"),currency=(0,schema_1.baseStringSchema)("Currency of the token"),chain=(0,schema_1.baseStringSchema)("Blockchain chain associated with the token"),network=(0,schema_1.baseStringSchema)("Network where the token operates"),type=(0,schema_1.baseStringSchema)("Type of the token"),decimals=(0,schema_1.baseNumberSchema)("Number of decimals for the token"),status=(0,schema_1.baseBooleanSchema)("Operational status of the token"),precision=(0,schema_1.baseNumberSchema)("Precision level of the token"),limits={type:"object",nullable:!0,properties:{deposit:{type:"object",properties:{min:(0,schema_1.baseNumberSchema)("Minimum deposit amount"),max:(0,schema_1.baseNumberSchema)("Maximum deposit amount")}},withdraw:{type:"object",properties:{min:(0,schema_1.baseNumberSchema)("Minimum withdrawal amount"),max:(0,schema_1.baseNumberSchema)("Maximum withdrawal amount")}}}},fee={type:"object",nullable:!0,properties:{min:(0,schema_1.baseNumberSchema)("Minimum fee amount"),percentage:(0,schema_1.baseNumberSchema)("Percentage fee amount")}},icon=(0,schema_1.baseStringSchema)("URL to the token icon",1e3,0,!0),contractType=(0,schema_1.baseEnumSchema)("Type of contract (PERMIT, NO_PERMIT, NATIVE)",["PERMIT","NO_PERMIT","NATIVE"]);exports.ecosystemTokenSchema={id:id,contract:contract,name:name,currency:currency,chain:chain,network:network,type:type,decimals:decimals,status:status,precision:precision,limits:limits,fee:fee,icon:icon,contractType:contractType};exports.baseEcosystemTokenSchema={id:id,contract:contract,name:name,currency:currency,chain:chain,network:network,type:type,decimals:decimals,status:status,precision:precision,limits:limits,fee:fee,icon:icon,contractType:contractType};exports.ecosystemTokenUpdateSchema={type:"object",properties:{icon:icon,fee:fee,limits:limits,status:status},required:[]};exports.ecosystemTokenDeploySchema={type:"object",properties:{name:name,currency:currency,chain:chain,type:type,decimals:decimals,status:status,precision:precision,limits:limits,fee:fee,icon:icon,initialSupply:(0,schema_1.baseNumberSchema)("Initial supply of the token"),initialHolder:(0,schema_1.baseStringSchema)("Address of the initial token holder"),marketCap:(0,schema_1.baseNumberSchema)("Maximum supply cap of the token")},required:["name","currency","chain","decimals","initialSupply","initialHolder","marketCap"]};exports.ecosystemTokenImportSchema={type:"object",properties:{icon:icon,name:name,currency:currency,chain:chain,network:network,contract:contract,contractType:contractType,decimals:decimals,precision:precision,type:type,fee:fee,limits:limits,status:status},required:["name","currency","chain","network","contract","decimals","type","contractType"]};exports.ecosystemTokenStoreSchema={description:"Ecosystem token created or updated successfully",content:{"application/json":{schema:exports.ecosystemTokenDeploySchema}}};