"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils"),query_2=require("@b/api/(ext)/ecosystem/utils/scylla/query");exports.metadata={summary:"Lists all ecosystem orders",description:"Retrieves a paginated list of all ecosystem orders with optional filtering and sorting. Orders include details about user trades, order types, status, prices, amounts, and fees.",operationId:"listEcosystemOrders",tags:["Admin","Ecosystem","Order"],parameters:constants_1.crudParameters,logModule:"ADMIN_ECO",logTitle:"List orders",responses:{200:{description:"Ecosystem orders retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.orderSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ecosystem Orders"),500:query_1.serverErrorResponse},permission:"view.ecosystem.order",requiresAuth:!0};const keyspace=process.env.SCYLLA_KEYSPACE||"trading";exports.default=async e=>{const{query:t,ctx:s}=e;null==s||s.step("Fetching ecosystem orders");const r=await(0,query_2.getFiltered)({table:"orders",query:t,filter:t.filter,sortField:t.sortField||"createdAt",sortOrder:t.sortOrder||"DESC",perPage:Number(t.perPage)||10,allowFiltering:!0,keyspace:keyspace,partitionKeys:["userId"],transformColumns:["amount","cost","fee","filled","price","remaining"],nonStringLikeColumns:["userId"]}),i=r.items.filter(e=>null!==e.symbol&&void 0!==e.symbol&&null!==e.amount&&void 0!==e.amount&&null!==e.price&&void 0!==e.price&&null!==e.side&&void 0!==e.side),o=r.items.length-i.length;if(o>0){r.pagination.totalItems=Math.max(0,r.pagination.totalItems-o);r.pagination.totalPages=Math.ceil(r.pagination.totalItems/r.pagination.perPage)}null==s||s.success("Orders retrieved successfully");return{items:i,pagination:r.pagination}};