"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),cleanup_1=require("@b/api/(ext)/ecosystem/utils/scylla/cleanup"),error_1=require("@b/utils/error");exports.metadata={summary:"Cleanup corrupted ecosystem orders",description:"Removes corrupted ecosystem orders with null essential fields. These are ghost records created by ScyllaDB's upsert behavior. Supports dry-run mode to preview what would be deleted.",operationId:"cleanupCorruptedEcosystemOrders",tags:["Admin","Ecosystem","Order","Maintenance"],logModule:"ADMIN_ECO",logTitle:"Cleanup corrupted orders",requestBody:{description:"Cleanup options",content:{"application/json":{schema:{type:"object",properties:{dryRun:{type:"boolean",description:"If true, only count corrupted orders without deleting them",default:!1},limit:{type:"number",description:"Maximum number of orders to scan",default:1e4,minimum:1,maximum:1e5}}}}}},responses:{200:{description:"Cleanup operation completed successfully",content:{"application/json":{schema:{type:"object",properties:{totalScanned:{type:"number",description:"Total number of orders scanned"},corruptedFound:{type:"number",description:"Number of corrupted orders found"},deleted:{type:"number",description:"Number of orders deleted (0 in dry-run mode)"},errors:{type:"number",description:"Number of errors encountered during deletion"},dryRun:{type:"boolean",description:"Whether this was a dry-run operation"}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},permission:"manage.ecosystem.order",requiresAuth:!0};exports.default=async e=>{var r,o;const{body:t,ctx:n}=e,s=null!==(r=null==t?void 0:t.dryRun)&&void 0!==r&&r,u=null!==(o=null==t?void 0:t.limit)&&void 0!==o?o:1e4;null==n||n.step("Validating cleanup parameters");if(u<1||u>1e5)throw(0,error_1.createError)({statusCode:400,message:"Limit must be between 1 and 100,000"});s?null==n||n.step(`Performing dry-run cleanup scan (limit: ${u})`):null==n||n.step(`Performing cleanup operation (limit: ${u})`);const d=await(0,cleanup_1.cleanupCorruptedOrders)(s,u);null==n||n.success(s?`Dry-run complete: found ${d.corruptedFound} corrupted orders out of ${d.totalScanned} scanned`:`Cleanup complete: deleted ${d.deleted} corrupted orders out of ${d.corruptedFound} found`);return{...d,dryRun:s}};