"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Retrieves ecosystem market options",description:"Fetches a list of active ecosystem markets formatted as options for UI selection components. Each option contains the market ID and a formatted name showing the trading pair (e.g., 'BTC / USDT').",operationId:"getEcosystemMarketOptions",tags:["Admin","Ecosystem","Market"],requiresAuth:!0,logModule:"ADMIN_ECO",logTitle:"Get market options",responses:{200:{description:"Ecosystem market options retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",format:"uuid",description:"Market ID"},name:{type:"string",description:"Formatted market name (currency / pair)"}}}}}}},401:errors_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ecosystem Market"),500:errors_1.serverErrorResponse}};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==t||t.step("Fetching active ecosystem markets");const e=await db_1.models.ecosystemMarket.findAll({where:{status:!0}});null==t||t.step("Formatting market options");const r=e.map(e=>({id:e.id,name:`${e.currency} / ${e.pair}`}));null==t||t.success("Market options retrieved successfully");return r}catch(e){null==t||t.fail(e.message);throw(0,error_1.createError)(500,"An error occurred while fetching ecosystem markets")}};