"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),queries_1=require("@b/api/(ext)/ecosystem/utils/scylla/queries"),query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error");exports.metadata={summary:"Bulk deletes ecosystem markets",description:"Deletes multiple ecosystem markets by their IDs. This operation also removes all associated market data from the database for each market. The markets are permanently deleted (force delete).",operationId:"bulkDeleteEcosystemMarkets",tags:["Admin","Ecosystem","Market"],parameters:(0,query_1.commonBulkDeleteParams)("Ecosystem Markets"),logModule:"ADMIN_ECO",logTitle:"Bulk delete markets",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string",format:"uuid"},description:"Array of ecosystem market IDs to delete (at least 1 required)"}},required:["ids"]}}}},responses:{200:{description:"Markets deleted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecosystem Market"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"delete.ecosystem.market"};exports.default=async e=>{const{body:r,query:t,ctx:s}=e,{ids:o}=r;if(!o||!Array.isArray(o)||0===o.length)throw(0,error_1.createError)(400,"No market IDs provided");null==s||s.step(`Fetching ${o.length} market(s) for deletion`);const a=await db_1.models.ecosystemMarket.findAll({where:{id:o},attributes:["currency"],paranoid:!1});console.log("🚀 ~ markets:",a);if(!a.length)throw(0,error_1.createError)(404,"No matching markets found for provided IDs");null==s||s.step("Deleting market records");const l=await(0,query_1.handleBulkDelete)({model:"ecosystemMarket",ids:o,query:{...t,force:!0},postDelete:async()=>{null==s||s.step("Deleting market data for all markets");for(const e of a)await(0,queries_1.deleteAllMarketData)(e.currency)}});null==s||s.success(`${o.length} market(s) deleted successfully`);return l};