"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Retrieves active ecommerce products for selection options",description:"Returns a simplified list of active ecommerce products (status: true) formatted for use in dropdowns and selection interfaces. Each product includes ID, name, price, and currency.",operationId:"getEcommerceProductOptions",tags:["Admin","Ecommerce","Product"],requiresAuth:!0,responses:{200:{description:"Active ecommerce products retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Product ID"},name:{type:"string",description:"Product name with price and currency (e.g., 'Product Name - 99.99 USD')"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ecommerce Products"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");null==t||t.step("Fetching product options");try{const e=(await db_1.models.ecommerceProduct.findAll({where:{status:!0}})).map(e=>({id:e.id,name:`${e.name} - ${e.price} ${e.currency}`}));null==t||t.success(`Retrieved ${e.length} product options`);return e}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching ecommerce products")}};