"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Creates a new ecommerce product",operationId:"createEcommerceProduct",tags:["Admin","Ecommerce","Product"],description:"Creates a new ecommerce product with the provided details. Validates category existence and status, checks for duplicate product names, and automatically generates a unique slug from the product name.",requestBody:{required:!0,content:{"application/json":{schema:utils_1.ecommerceProductUpdateSchema}}},responses:(0,query_1.storeRecordResponses)(utils_1.ecommerceProductStoreSchema,"Ecommerce Product"),requiresAuth:!0,permission:"create.ecommerce.product",logModule:"ADMIN_ECOM",logTitle:"Create Ecommerce Product"};exports.default=async e=>{const{body:r,ctx:t}=e,{name:o,description:c,shortDescription:a,type:s,price:i,categoryId:u,inventoryQuantity:d,filePath:n,status:m,image:l,currency:p,walletType:y}=r;if(!u)throw(0,error_1.createError)({statusCode:400,message:"Category ID is required"});null==t||t.step("Validating category");if(!await db_1.models.ecommerceCategory.findOne({where:{id:u,status:!0}}))throw(0,error_1.createError)({statusCode:400,message:"Invalid category ID or category is inactive"});null==t||t.step("Checking for duplicate product");if(await db_1.models.ecommerceProduct.findOne({where:{name:o}}))throw(0,error_1.createError)({statusCode:400,message:"Product with this name already exists"});null==t||t.step("Creating E-commerce product");const g=await(0,query_1.storeRecord)({model:"ecommerceProduct",data:{name:o,description:c,shortDescription:a,type:s,price:i,categoryId:u,inventoryQuantity:d,filePath:n,status:m,image:l,currency:p,walletType:y}});null==t||t.success("Successfully created E-commerce product");return g};