"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Ecommerce Dashboard Data",description:"Retrieves all key data for the admin ecommerce dashboard.",operationId:"getAdminEcommerceDashboard",tags:["Ecommerce","Admin","Dashboard"],requiresAuth:!0,logModule:"ADMIN_ECOM",logTitle:"Get dashboard data",parameters:[{name:"startDate",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Start date for chart/statistics range (ISO format)"},{name:"endDate",in:"query",required:!1,schema:{type:"string",format:"date"},description:"End date for chart/statistics range (ISO format)"},{name:"chartType",in:"query",required:!1,schema:{type:"string",enum:["revenue","orders","customers"]},description:"Metric to use for the sales chart"}],responses:{200:{description:"Ecommerce dashboard data retrieved",content:{"application/json":{schema:{type:"object"}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"access.ecommerce.dashboard",demoMask:["recentOrders.customer.email"]};exports.default=async e=>{const{user:t,query:r,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==a||a.step("Parsing date range and chart parameters");const s=new Date,{startDate:d,endDate:o,chartType:n}=r||{};let c=d?new Date(d):new Date(s),i=o?new Date(o):s;if(!d||!o){i=s;c=new Date(s);c.setDate(i.getDate()-7)}const u=n||"revenue",l=i.getTime()-c.getTime(),m=new Date(c.getTime()-l),g=new Date(c.getTime());try{null==a||a.step("Fetching products data");const h=(await db_1.models.ecommerceProduct.findAll({include:[{model:db_1.models.ecommerceOrderItem,as:"ecommerceOrderItems",attributes:[]},{model:db_1.models.ecommerceCategory,as:"category",attributes:["id","name"]}],attributes:{include:[[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("ecommerceOrderItems.quantity")),0),"soldCount"]]},group:["ecommerceProduct.id","category.id"],raw:!1,paranoid:!1})).map(e=>({...e.get({plain:!0}),soldCount:Number(e.get("soldCount")||0)}));null==a||a.step("Fetching orders data");const p=(await db_1.models.ecommerceOrder.findAll({include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email"]},{model:db_1.models.ecommerceOrderItem,as:"ecommerceOrderItems",attributes:["productId","quantity"]}],order:[["createdAt","DESC"]],paranoid:!1})).map(e=>{const t=e.get({plain:!0});t.customer=t.user?{name:t.user.firstName+" "+t.user.lastName,email:t.user.email}:{name:"Guest",email:""};t.total=(t.ecommerceOrderItems||[]).reduce((e,t)=>e+(t.quantity||0),0);return t});null==a||a.step("Fetching customers data");const D=(await db_1.models.user.findAll({include:[{model:db_1.models.ecommerceOrder,as:"ecommerceOrders",required:!0,attributes:[]}],attributes:["id","firstName","lastName","email","createdAt",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("ecommerceOrders.id")),"orderCount"]],group:["user.id"],order:[["createdAt","DESC"]],paranoid:!1})).map(e=>e.get({plain:!0}));null==a||a.step("Calculating current period statistics");const f=p.filter(e=>("COMPLETED"===e.status||"DELIVERED"===e.status)&&e.createdAt>=c&&e.createdAt<=i),y=f.reduce((e,t)=>e+(t.ecommerceOrderItems||[]).reduce((e,t)=>{const r=h.find(e=>e.id===t.productId);return e+((null==r?void 0:r.price)||0)*(t.quantity||0)},0),0),b=p.filter(e=>e.createdAt>=c&&e.createdAt<=i),C=b.length,E=C>0?y/C:0,O=f.reduce((e,t)=>e+(t.ecommerceOrderItems||[]).reduce((e,t)=>e+(t.quantity||0),0),0),A=D.filter(e=>e.createdAt>=c&&e.createdAt<=i).length,q=b.filter(e=>"PENDING"===e.status).length,I=h.filter(e=>0===(e.inventoryQuantity||0)).length,M=b.filter(e=>"SHIPPED"===e.status&&e.updatedAt&&new Date(e.updatedAt).toDateString()===s.toDateString()).length,v=b.filter(e=>"DELIVERED"===e.status).length;null==a||a.step("Calculating previous period statistics");const w=p.filter(e=>("COMPLETED"===e.status||"DELIVERED"===e.status)&&e.createdAt>=m&&e.createdAt<g),S=w.reduce((e,t)=>e+(t.ecommerceOrderItems||[]).reduce((e,t)=>{const r=h.find(e=>e.id===t.productId);return e+((null==r?void 0:r.price)||0)*(t.quantity||0)},0),0),_=p.filter(e=>e.createdAt>=m&&e.createdAt<g).length,F=_>0?S/_:0,T=w.reduce((e,t)=>e+(t.ecommerceOrderItems||[]).reduce((e,t)=>e+(t.quantity||0),0),0),Y=D.filter(e=>e.createdAt>=m&&e.createdAt<g).length;function N(e,t){return 0===t&&0===e?0:0===t?100:(e-t)/t*100}const P=N(y,S),L=N(C,_),z=N(E,F),U=N(O,T),R=N(A,Y);null==a||a.step("Building chart data");function V(e,t,r){const a=[],s=[],d=r.getTime()-t.getTime()>3456e6?"month":"day",o=new Date(t);for(;o<=r;){a.push("day"===d?o.toLocaleDateString("en-US",{month:"short",day:"numeric"}):o.toLocaleDateString("en-US",{month:"short",year:"numeric"}));let t=0;if("revenue"===e||"unitsSold"===e){t=p.filter(e=>{const t=new Date(e.createdAt);return"day"===d?t.getFullYear()===o.getFullYear()&&t.getMonth()===o.getMonth()&&t.getDate()===o.getDate():t.getFullYear()===o.getFullYear()&&t.getMonth()===o.getMonth()}).reduce((t,r)=>"COMPLETED"!==r.status&&"DELIVERED"!==r.status?t:"revenue"===e?t+(r.ecommerceOrderItems||[]).reduce((e,t)=>{const r=h.find(e=>e.id===t.productId);return e+((null==r?void 0:r.price)||0)*(t.quantity||0)},0):"unitsSold"===e?t+(r.ecommerceOrderItems||[]).reduce((e,t)=>e+(t.quantity||0),0):t,0)}else"orders"===e?t=p.filter(e=>{const t=new Date(e.createdAt);return"day"===d?t.getFullYear()===o.getFullYear()&&t.getMonth()===o.getMonth()&&t.getDate()===o.getDate():t.getFullYear()===o.getFullYear()&&t.getMonth()===o.getMonth()}).length:"customers"===e&&(t=D.filter(e=>{const t=new Date(e.createdAt);return"day"===d?t.getFullYear()===o.getFullYear()&&t.getMonth()===o.getMonth()&&t.getDate()===o.getDate():t.getFullYear()===o.getFullYear()&&t.getMonth()===o.getMonth()}).length);s.push(t);if("day"===d)o.setDate(o.getDate()+1);else{const e=o.getDate();o.setMonth(o.getMonth()+1);o.getDate()<e&&o.setDate(0)}if(a.length>400)break}return{labels:a,data:s}}const x=V("revenue",c,i),k=V("orders",c,i),G=V("unitsSold",c,i),j=V("customers",c,i);null==a||a.step("Compiling dashboard summary");const B=[...h].sort((e,t)=>(t.soldCount||0)-(e.soldCount||0)).slice(0,5),H=[...p].sort((e,t)=>new Date(t.createdAt||0).getTime()-new Date(e.createdAt||0).getTime()).slice(0,5);null==a||a.success("Dashboard data retrieved successfully");return{totalRevenue:y,totalOrders:C,averageOrderValue:E,totalUnitsSold:O,newCustomers:A,revenueChange:P,ordersChange:L,averageOrderChange:z,unitsSoldChange:U,newCustomersChange:R,revenueChartData:x.data,orderValueChartData:k.data,unitsSoldChartData:G.data,customersChartData:j.data,topProducts:B,chartData:{labels:x.labels,datasets:[{label:u,data:"revenue"===u?x.data:"orders"===u?k.data:"customers"===u?j.data:[]}]},pendingOrders:q,outOfStockCount:I,shippedToday:M,completedOrders:v,recentOrders:H}}catch(Q){null==a||a.fail("Failed to fetch dashboard data");console.error("Failed to fetch ecommerce dashboard data",Q);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch dashboard data"})}};