"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk updates ecommerce category status",description:"Updates the status (active/inactive) of multiple ecommerce categories simultaneously. Set status to true to activate categories or false to deactivate them.",operationId:"bulkUpdateEcommerceCategoryStatus",tags:["Admin","Ecommerce","Category"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of ecommerce category IDs to update",items:{type:"string"}},status:{type:"boolean",description:"New status to apply to the ecommerce categories (true for active, false for inactive)"}},required:["ids","status"]}}}},responses:{200:{description:"Category status updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecommerce category"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"edit.ecommerce.category",logModule:"ADMIN_ECOM",logTitle:"Bulk update category status"};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:r,status:o}=t;null==s||s.step(`Validating ${r.length} category IDs`);null==s||s.step(`Updating status to ${o} for ${r.length} categories`);const a=await(0,query_1.updateStatus)("ecommerceCategory",r,o);null==s||s.success(`Successfully updated status for ${r.length} categories`);return a};