"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Lists all ecommerce categories",description:"Retrieves a paginated list of ecommerce categories with optional filtering and sorting. Supports search, status filtering, and custom sort fields.",operationId:"listEcommerceCategories",tags:["Admin","Ecommerce","Category"],parameters:constants_1.crudParameters,responses:{200:{description:"List of ecommerce categories retrieved successfully with pagination metadata",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.ecommerceCategorySchema}},pagination:constants_1.paginationSchema}}}}},401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecommerce category"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"view.ecommerce.category",logModule:"ADMIN_ECOM",logTitle:"List categories"};exports.default=async e=>{const{query:r,ctx:t}=e;null==t||t.step("Parsing query parameters");null==t||t.step("Fetching categories from database");const s=await(0,query_1.getFiltered)({model:db_1.models.ecommerceCategory,query:r,sortField:r.sortField||"name"});null==t||t.success("Categories retrieved successfully");return s};