"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get Copy Trading System Health",description:"Retrieves system health status and metrics for copy trading including trade metrics from the last 24 hours, latency statistics (average, P95, P99), failure rates, active subscriptions and leaders, database connectivity, recent errors, and overall system status (healthy/degraded/critical).",operationId:"getAdminCopyTradingHealth",tags:["Admin","Copy Trading","Health"],requiresAuth:!0,logModule:"ADMIN_COPY",logTitle:"Get Copy Trading Health",permission:"access.copy_trading",responses:{200:{description:"Health status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"string",enum:["healthy","degraded","critical"],description:"Overall system health status"},timestamp:{type:"string",format:"date-time"},metrics:{type:"object",properties:{totalTrades24h:{type:"integer"},executedTrades24h:{type:"integer"},failedTrades24h:{type:"integer"},pendingTrades:{type:"integer"},failureRate:{type:"number"},avgLatencyMs:{type:"integer"},p95LatencyMs:{type:"integer"},p99LatencyMs:{type:"integer"},activeSubscriptions:{type:"integer"},activeLeaders:{type:"integer"}}},services:{type:"object",properties:{database:{type:"string",description:"Database service status"},copyTradingEngine:{type:"string",description:"Copy trading engine status"}}},alerts:{type:"array",description:"Active system alerts",items:{type:"object",properties:{severity:{type:"string"},type:{type:"string"},message:{type:"string"},timestamp:{type:"string",format:"date-time"}}}},recentErrors:{type:"array",description:"Recent errors from audit log"}}}}}},401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const a=new Date,s=new Date(a.getTime()-864e5),i=new Date(a.getTime()-36e5);null==r||r.step("Get Copy Trading Health");const n=await db_1.models.copyTradingTrade.findAll({where:{createdAt:{[sequelize_1.Op.gte]:s},followerId:{[sequelize_1.Op.ne]:null}},attributes:["status","latencyMs"]}),d=n.length,o=n.filter(e=>"EXECUTED"===e.status||"CLOSED"===e.status).length,c=n.filter(e=>"FAILED"===e.status).length,l=n.filter(e=>"PENDING"===e.status).length,p=n.map(e=>e.latencyMs).filter(e=>null!=e&&e>0).sort((e,t)=>e-t),u=p.length>0?p.reduce((e,t)=>e+t,0)/p.length:0,y=Math.floor(.95*p.length),g=Math.floor(.99*p.length),h=p[y]||0,m=p[g]||0,f=d>0?c/d*100:0,T=await db_1.models.copyTradingFollower.count({where:{status:"ACTIVE"}}),v=await db_1.models.copyTradingLeader.count({where:{status:"ACTIVE"}});let b="up";try{await db_1.sequelize.authenticate()}catch(e){b="down"}const _=await db_1.models.copyTradingAuditLog.findAll({where:{action:{[sequelize_1.Op.like]:"%ERROR%"},createdAt:{[sequelize_1.Op.gte]:i}},order:[["createdAt","DESC"]],limit:10});let w="healthy";const A=[];if(f>20){w="critical";A.push({severity:"critical",type:"high_failure_rate",message:`Trade failure rate is ${f.toFixed(1)}%`,timestamp:a})}else if(f>10){w="degraded";A.push({severity:"warning",type:"elevated_failure_rate",message:`Trade failure rate is ${f.toFixed(1)}%`,timestamp:a})}if(u>5e3){w="critical"===w?"critical":"degraded";A.push({severity:"warning",type:"high_latency",message:`Average latency is ${u.toFixed(0)}ms`,timestamp:a})}if("down"===b){w="critical";A.push({severity:"critical",type:"database_down",message:"Database connection failed",timestamp:a})}l>100&&A.push({severity:"warning",type:"queue_backlog",message:`${l} trades pending execution`,timestamp:a});null==r||r.success("Get Copy Trading Health retrieved successfully");return{status:w,timestamp:a,metrics:{totalTrades24h:d,executedTrades24h:o,failedTrades24h:c,pendingTrades:l,failureRate:Math.round(100*f)/100,avgLatencyMs:Math.round(u),p95LatencyMs:Math.round(h),p99LatencyMs:Math.round(m),activeSubscriptions:T,activeLeaders:v},services:{database:b,copyTradingEngine:l<100?"up":"degraded"},alerts:A,recentErrors:_.map(e=>({id:e.id,action:e.action,entityType:e.entityType,entityId:e.entityId,createdAt:e.createdAt}))}};