"use strict";function toBigIntSafe(e){return null==e?BigInt(0):"bigint"==typeof e?e:BigInt(e.toString())}function mapRowToOrder(e){var t,r,a,o;return{marketId:null===(t=e.market_id)||void 0===t?void 0:t.toString(),botId:null===(r=e.bot_id)||void 0===r?void 0:r.toString(),orderId:null===(a=e.order_id)||void 0===a?void 0:a.toString(),side:e.side,type:e.type,price:toBigIntSafe(e.price),amount:toBigIntSafe(e.amount),filledAmount:toBigIntSafe(e.filled_amount),status:e.status,purpose:e.purpose,matchedWithBotId:null===(o=e.matched_with_bot_id)||void 0===o?void 0:o.toString(),createdAt:e.created_at,updatedAt:e.updated_at}}function mapRowToTrade(e){var t,r,a,o,n,i;return{marketId:null===(t=e.market_id)||void 0===t?void 0:t.toString(),tradeDate:e.trade_date,tradeTime:e.trade_time,tradeId:null===(r=e.trade_id)||void 0===r?void 0:r.toString(),buyBotId:null===(a=e.buy_bot_id)||void 0===a?void 0:a.toString(),sellBotId:null===(o=e.sell_bot_id)||void 0===o?void 0:o.toString(),buyOrderId:null===(n=e.buy_order_id)||void 0===n?void 0:n.toString(),sellOrderId:null===(i=e.sell_order_id)||void 0===i?void 0:i.toString(),price:toBigIntSafe(e.price),amount:toBigIntSafe(e.amount)}}function mapRowToPriceHistory(e){var t;return{marketId:null===(t=e.market_id)||void 0===t?void 0:t.toString(),timestamp:e.timestamp,price:toBigIntSafe(e.price),volume:toBigIntSafe(e.volume),isAiTrade:e.is_ai_trade,source:e.source}}async function insertBotOrder(e){const t=(0,passwords_1.makeUuid)(),r=new Date,a=`\n    INSERT INTO ${client_1.aiMarketMakerKeyspace}.ai_bot_orders (\n      market_id, bot_id, order_id, side, type, price, amount,\n      filled_amount, status, purpose, matched_with_bot_id, created_at, updated_at\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n  `,o=[cassandra_driver_1.types.Uuid.fromString(e.marketId),cassandra_driver_1.types.Uuid.fromString(e.botId),cassandra_driver_1.types.Uuid.fromString(t),e.side,e.type,e.price.toString(),e.amount.toString(),e.filledAmount.toString(),e.status,e.purpose,e.matchedWithBotId?cassandra_driver_1.types.Uuid.fromString(e.matchedWithBotId):null,r,r];await client_1.default.execute(a,o,{prepare:!0});return t}async function updateBotOrder(e,t,r,a){const o=[],n=[];if(void 0!==a.filledAmount){o.push("filled_amount = ?");n.push(a.filledAmount.toString())}if(void 0!==a.status){o.push("status = ?");n.push(a.status)}if(void 0!==a.matchedWithBotId){o.push("matched_with_bot_id = ?");n.push(cassandra_driver_1.types.Uuid.fromString(a.matchedWithBotId))}o.push("updated_at = ?");n.push(new Date);n.push(cassandra_driver_1.types.Uuid.fromString(e));n.push(r);n.push(cassandra_driver_1.types.Uuid.fromString(t));const i=`\n    UPDATE ${client_1.aiMarketMakerKeyspace}.ai_bot_orders\n    SET ${o.join(", ")}\n    WHERE market_id = ? AND created_at = ? AND order_id = ?\n  `;await client_1.default.execute(i,n,{prepare:!0})}async function getBotOrdersByMarket(e,t=100){const r=`\n    SELECT * FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_orders\n    WHERE market_id = ?\n    LIMIT ?\n  `;return(await client_1.default.execute(r,[cassandra_driver_1.types.Uuid.fromString(e),t],{prepare:!0})).rows.map(mapRowToOrder)}async function getBotOrdersByBot(e,t=100){const r=`\n    SELECT * FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_orders_by_bot\n    WHERE bot_id = ?\n    LIMIT ?\n  `;return(await client_1.default.execute(r,[cassandra_driver_1.types.Uuid.fromString(e),t],{prepare:!0})).rows.map(mapRowToOrder)}async function getOpenBotOrders(e){const t=`\n    SELECT * FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_open_orders\n    WHERE status = 'OPEN' AND market_id = ?\n  `;return(await client_1.default.execute(t,[cassandra_driver_1.types.Uuid.fromString(e)],{prepare:!0})).rows.map(mapRowToOrder)}async function cancelBotOrder(e,t,r){await updateBotOrder(e,t,r,{status:"CANCELLED"})}async function insertBotTrade(e){const t=(0,passwords_1.makeUuid)(),r=new Date,a=new cassandra_driver_1.types.LocalDate(r.getFullYear(),r.getMonth()+1,r.getDate()),o=`\n    INSERT INTO ${client_1.aiMarketMakerKeyspace}.ai_bot_trades (\n      market_id, trade_date, trade_time, trade_id, buy_bot_id, sell_bot_id,\n      buy_order_id, sell_order_id, price, amount\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n  `,n=[cassandra_driver_1.types.Uuid.fromString(e.marketId),a,r,cassandra_driver_1.types.Uuid.fromString(t),cassandra_driver_1.types.Uuid.fromString(e.buyBotId),cassandra_driver_1.types.Uuid.fromString(e.sellBotId),cassandra_driver_1.types.Uuid.fromString(e.buyOrderId),cassandra_driver_1.types.Uuid.fromString(e.sellOrderId),e.price.toString(),e.amount.toString()];try{await client_1.default.execute(o,n,{prepare:!0})}catch(t){console_1.logger.error("AI_MM",`Failed to insert trade for market ${e.marketId}: ${t}`);throw t}return t}async function getBotTradesByMarket(e,t,r=100){const a=new cassandra_driver_1.types.LocalDate(t.getFullYear(),t.getMonth()+1,t.getDate()),o=`\n    SELECT * FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_trades\n    WHERE market_id = ? AND trade_date = ?\n    LIMIT ?\n  `;return(await client_1.default.execute(o,[cassandra_driver_1.types.Uuid.fromString(e),a,r],{prepare:!0})).rows.map(mapRowToTrade)}async function getBotTradesInRange(e,t,r,a=1e3){const o=[],n=new Date(t);for(;n<=r&&o.length<a;){const t=await getBotTradesByMarket(e,n,a-o.length);o.push(...t);n.setDate(n.getDate()+1)}return o}async function getDailyTradeVolume(e,t){return(await getBotTradesByMarket(e,t,1e4)).reduce((e,t)=>e+t.amount,BigInt(0))}async function insertPriceHistory(e){const t=`\n    INSERT INTO ${client_1.aiMarketMakerKeyspace}.ai_price_history (\n      market_id, timestamp, price, volume, is_ai_trade, source\n    ) VALUES (?, ?, ?, ?, ?, ?)\n  `,r=[cassandra_driver_1.types.Uuid.fromString(e.marketId),new Date,e.price.toString(),e.volume.toString(),e.isAiTrade,e.source];await client_1.default.execute(t,r,{prepare:!0})}async function getPriceHistory(e,t=100){const r=`\n    SELECT * FROM ${client_1.aiMarketMakerKeyspace}.ai_price_history\n    WHERE market_id = ?\n    LIMIT ?\n  `;return(await client_1.default.execute(r,[cassandra_driver_1.types.Uuid.fromString(e),t],{prepare:!0})).rows.map(mapRowToPriceHistory)}async function getPriceHistoryInRange(e,t,r,a=1e3){const o=`\n    SELECT * FROM ${client_1.aiMarketMakerKeyspace}.ai_price_history\n    WHERE market_id = ? AND timestamp >= ? AND timestamp <= ?\n    LIMIT ?\n  `;return(await client_1.default.execute(o,[cassandra_driver_1.types.Uuid.fromString(e),t,r,a],{prepare:!0})).rows.map(mapRowToPriceHistory)}async function getLatestPrice(e){const t=`\n    SELECT * FROM ${client_1.aiMarketMakerKeyspace}.ai_price_history\n    WHERE market_id = ?\n    LIMIT 1\n  `,r=await client_1.default.execute(t,[cassandra_driver_1.types.Uuid.fromString(e)],{prepare:!0});return 0===r.rows.length?null:mapRowToPriceHistory(r.rows[0])}async function calculateVolatility(e,t=60){const r=new Date,a=new Date(r.getTime()-60*t*1e3),o=await getPriceHistoryInRange(e,a,r,1e3);if(o.length<2)return 0;const n=o.map(e=>Number(e.price)),i=[];for(let e=1;e<n.length;e++)0!==n[e-1]&&i.push((n[e]-n[e-1])/n[e-1]);if(0===i.length)return 0;const s=i.reduce((e,t)=>e+t,0)/i.length,d=i.map(e=>Math.pow(e-s,2)).reduce((e,t)=>e+t,0)/i.length;return 100*Math.sqrt(d)}async function placeRealOrder(e,t,r,a,o,n,i){const[s,d]=e.split("/"),c=i,l=r*a/BigInt(10**18),u=BigInt(0),_="BUY"===t?d:s,p=await(0,queries_1.createOrder)({userId:c,symbol:e,amount:a,price:r,cost:l,type:"LIMIT",side:t,fee:u,feeCurrency:_,marketMakerId:n,botId:i});await(0,queries_1.addOrderToMatchingQueue)(p);await trackRealLiquidityOrder({aiBotOrderId:o,ecosystemOrderId:p.id,symbol:e,side:t,price:r,amount:a});return p}async function cancelRealOrder(e,t,r,a,o,n,i){await(0,queries_1.cancelOrderByUuid)(t,e,r,a,o,n,i);await updateRealLiquidityOrderStatus(e,"CANCELLED")}async function trackRealLiquidityOrder(e){const t=`\n    INSERT INTO ${client_1.aiMarketMakerKeyspace}.ai_real_liquidity_orders (\n      ai_order_id, ecosystem_order_id, symbol, side, price, amount, status, created_at\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)\n  `;await client_1.default.execute(t,[cassandra_driver_1.types.Uuid.fromString(e.aiBotOrderId),cassandra_driver_1.types.Uuid.fromString(e.ecosystemOrderId),e.symbol,e.side,e.price.toString(),e.amount.toString(),"OPEN",new Date],{prepare:!0})}async function updateRealLiquidityOrderStatus(e,t){const r=`\n    UPDATE ${client_1.aiMarketMakerKeyspace}.ai_real_liquidity_orders\n    SET status = ?\n    WHERE ecosystem_order_id = ?\n  `;await client_1.default.execute(r,[t,cassandra_driver_1.types.Uuid.fromString(e)],{prepare:!0})}async function syncOrderbookFromAiTrade(e,t,r){const a=orderbookUpdateLocks.get(e);if(a)try{await a}catch(e){}const o=syncOrderbookFromAiTradeInternal(e,t,r);orderbookUpdateLocks.set(e,o);try{await o}finally{orderbookUpdateLocks.get(e)===o&&orderbookUpdateLocks.delete(e)}}async function syncOrderbookFromAiTradeInternal(e,t,r){const a=[.001,.002,.003,.004,.005],o=[],n=[];for(const e of a){const a=t*(1-e),i=r*(.5+1*Math.random());o.push({price:a,amount:i});const s=t*(1+e),d=r*(.5+1*Math.random());n.push({price:s,amount:d})}const i=[],s=["BIDS","ASKS"];for(const t of s){const r=`\n      SELECT price FROM ${client_1.scyllaKeyspace}.orderbook\n      WHERE symbol = ? AND side = ?\n    `;try{const a=await client_1.default.execute(r,[e,t],{prepare:!0});for(const r of a.rows)i.push({query:`DELETE FROM ${client_1.scyllaKeyspace}.orderbook WHERE symbol = ? AND side = ? AND price = ?`,params:[e,t,r.price]})}catch(r){console_1.logger.error("AI_MM",`Failed to get orderbook entries for ${e} ${t}: ${r}`)}}for(const t of o)i.push({query:`INSERT INTO ${client_1.scyllaKeyspace}.orderbook (symbol, price, amount, side) VALUES (?, ?, ?, ?)`,params:[e,t.price,t.amount,"BIDS"]});for(const t of n)i.push({query:`INSERT INTO ${client_1.scyllaKeyspace}.orderbook (symbol, price, amount, side) VALUES (?, ?, ?, ?)`,params:[e,t.price,t.amount,"ASKS"]});if(i.length>0)try{await client_1.default.batch(i,{prepare:!0})}catch(t){console_1.logger.error("AI_MM",`Failed to update orderbook batch for ${e}: ${t}`);console_1.logger.warn("AI_MM",`Falling back to individual orderbook updates for ${e}`);await clearOrderbookForSymbol(e);for(const t of o)try{await(0,queries_1.updateOrderBookInDB)(e,t.price,t.amount,"BIDS")}catch(e){console_1.logger.error("AI_MM",`Failed to insert bid: ${e}`)}for(const t of n)try{await(0,queries_1.updateOrderBookInDB)(e,t.price,t.amount,"ASKS")}catch(e){console_1.logger.error("AI_MM",`Failed to insert ask: ${e}`)}}}async function syncTradeToEcosystem(e,t,r,a){await(0,queries_1.insertTrade)(e,t,r,a,!0)}async function clearCandlesForSymbol(e){const t=["1m","3m","5m","15m","30m","1h","2h","4h","6h","12h","1d","3d","1w"];for(const r of t)try{const t=`\n        SELECT "createdAt" FROM ${client_1.scyllaKeyspace}.candles\n        WHERE symbol = ? AND interval = ?\n      `,a=await client_1.default.execute(t,[e,r],{prepare:!0});for(const t of a.rows){const a=`\n          DELETE FROM ${client_1.scyllaKeyspace}.candles\n          WHERE symbol = ? AND interval = ? AND "createdAt" = ?\n        `;await client_1.default.execute(a,[e,r,t.createdAt],{prepare:!0})}a.rows.length>0&&console_1.logger.debug("AI_MM",`Cleared ${a.rows.length} ${r} candles for ${e}`)}catch(t){console_1.logger.error("AI_MM",`Failed to clear ${r} candles for ${e}: ${t}`)}}async function clearOrderbookForSymbol(e){const t=["BIDS","ASKS"];let r=0;for(const a of t){const t=`\n      SELECT price FROM ${client_1.scyllaKeyspace}.orderbook\n      WHERE symbol = ? AND side = ?\n    `;try{const o=await client_1.default.execute(t,[e,a],{prepare:!0});for(const t of o.rows){const o=`\n          DELETE FROM ${client_1.scyllaKeyspace}.orderbook\n          WHERE symbol = ? AND side = ? AND price = ?\n        `;await client_1.default.execute(o,[e,a,t.price],{prepare:!0});r++}console_1.logger.debug("AI_MM",`Cleared ${o.rows.length} ${a} orderbook entries for ${e}`)}catch(t){console_1.logger.error("AI_MM",`Failed to clear orderbook for ${e} ${a}: ${t}`)}}console_1.logger.debug("AI_MM",`Total cleared: ${r} orderbook entries for ${e}`)}async function forceCleanOrderbook(e){let t=0;try{const r=`\n      SELECT symbol, side, price FROM ${client_1.scyllaKeyspace}.orderbook_by_symbol\n      WHERE symbol = ?\n    `,a=await client_1.default.execute(r,[e],{prepare:!0});console_1.logger.debug("AI_MM",`Found ${a.rows.length} total orderbook entries to clear for ${e}`);for(const e of a.rows)try{const r=`\n          DELETE FROM ${client_1.scyllaKeyspace}.orderbook\n          WHERE symbol = ? AND side = ? AND price = ?\n        `;await client_1.default.execute(r,[e.symbol,e.side,e.price],{prepare:!0});t++}catch(e){console_1.logger.error("AI_MM",`Failed to delete entry: ${e}`)}console_1.logger.debug("AI_MM",`Force cleared ${t} orderbook entries for ${e}`);return t}catch(t){console_1.logger.error("AI_MM",`Force clean orderbook failed for ${e}: ${t}`);await clearOrderbookForSymbol(e);return-1}}async function getLastCandleClosePrice(e){try{const t=`\n      SELECT close FROM ${client_1.scyllaKeyspace}.candles\n      WHERE symbol = ? AND interval = '1m'\n      ORDER BY "createdAt" DESC\n      LIMIT 1\n    `,r=await client_1.default.execute(t,[e],{prepare:!0});return r.rows.length>0&&null!=r.rows[0].close?r.rows[0].close:null}catch(t){console_1.logger.error("AI_MM",`Failed to get last candle price for ${e}: ${t}`);return null}}function normalizeToIntervalBoundary(e,t){const r=new Date(e);switch(t){case"1w":const e=r.getUTCDay();r.setUTCDate(r.getUTCDate()-e);r.setUTCHours(0,0,0,0);break;case"3d":return 3*Math.floor(r.getTime()/2592e5)*24*60*60*1e3;case"1d":r.setUTCHours(0,0,0,0);break;case"12h":const t=12*Math.floor(r.getUTCHours()/12);r.setUTCHours(t,0,0,0);break;case"6h":const a=6*Math.floor(r.getUTCHours()/6);r.setUTCHours(a,0,0,0);break;case"4h":const o=4*Math.floor(r.getUTCHours()/4);r.setUTCHours(o,0,0,0);break;case"2h":const n=2*Math.floor(r.getUTCHours()/2);r.setUTCHours(n,0,0,0);break;case"1h":r.setUTCMinutes(0,0,0);break;case"30m":const i=30*Math.floor(r.getUTCMinutes()/30);r.setUTCMinutes(i,0,0);break;case"15m":const s=15*Math.floor(r.getUTCMinutes()/15);r.setUTCMinutes(s,0,0);break;case"5m":const d=5*Math.floor(r.getUTCMinutes()/5);r.setUTCMinutes(d,0,0);break;case"3m":const c=3*Math.floor(r.getUTCMinutes()/3);r.setUTCMinutes(c,0,0);break;case"1m":r.setUTCSeconds(0,0);break;default:r.setUTCMilliseconds(0)}return r.getTime()}async function syncCandlesFromAiTrade(e,t,r){const a=["1m","3m","5m","15m","30m","1h","2h","4h","6h","12h","1d","3d","1w"],o=new Date;for(const n of a){const a=normalizeToIntervalBoundary(o.getTime(),n),i=new Date(a);try{const a=`\n        SELECT open, high, low, close, volume FROM ${client_1.scyllaKeyspace}.candles\n        WHERE symbol = ? AND interval = ? AND "createdAt" = ?\n      `,s=await client_1.default.execute(a,[e,n,i],{prepare:!0});if(s.rows.length>0){const a=s.rows[0],d=Math.max(a.high,t),c=Math.min(a.low,t),l=(a.volume||0)+r,u=`\n          UPDATE ${client_1.scyllaKeyspace}.candles\n          SET high = ?, low = ?, close = ?, volume = ?, "updatedAt" = ?\n          WHERE symbol = ? AND interval = ? AND "createdAt" = ?\n        `;await client_1.default.execute(u,[d,c,t,l,o,e,n,i],{prepare:!0})}else{const a=getPreviousCandleTime(i,n),s=`\n          SELECT close FROM ${client_1.scyllaKeyspace}.candles\n          WHERE symbol = ? AND interval = ? AND "createdAt" = ?\n        `,d=await client_1.default.execute(s,[e,n,a],{prepare:!0}),c=d.rows.length>0?d.rows[0].close:t,l=`\n          INSERT INTO ${client_1.scyllaKeyspace}.candles (\n            symbol, interval, "createdAt", "updatedAt", open, high, low, close, volume\n          ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\n        `;await client_1.default.execute(l,[e,n,i,o,c,Math.max(c,t),Math.min(c,t),t,r],{prepare:!0})}}catch(t){console_1.logger.error("AI_MM",`Failed to sync candle for ${e} ${n}: ${t}`)}}}function getPreviousCandleTime(e,t){const r=intervalDurations[t]||intervalDurations["1m"];return new Date(e.getTime()-r)}function getCandleTime(e,t){return new Date(normalizeToIntervalBoundary(e.getTime(),t))}async function getRealLiquidityOrdersBySymbol(e,t){let r=`\n    SELECT * FROM ${client_1.aiMarketMakerKeyspace}.ai_real_liquidity_orders\n    WHERE symbol = ?\n  `;const a=[e];if(t){r+=" AND status = ?";a.push(t)}r+=" ALLOW FILTERING";return(await client_1.default.execute(r,a,{prepare:!0})).rows.map(e=>{var t,r,a;return{id:null===(t=e.ai_order_id)||void 0===t?void 0:t.toString(),aiBotOrderId:null===(r=e.ai_order_id)||void 0===r?void 0:r.toString(),ecosystemOrderId:null===(a=e.ecosystem_order_id)||void 0===a?void 0:a.toString(),symbol:e.symbol,side:e.side,price:toBigIntSafe(e.price),amount:toBigIntSafe(e.amount),status:e.status,createdAt:e.created_at}})}function calculateLiquiditySplit(e,t){const r=Math.max(0,Math.min(100,t)),a=e*BigInt(Math.round(100*r))/BigInt(1e4);return{aiAmount:e-a,realAmount:a}}async function getBotTradeStats(e){var t,r;const a=new Map;try{const o=[];for(let e=0;e<7;e++){const t=new Date;t.setDate(t.getDate()-e);o.push(new cassandra_driver_1.types.LocalDate(t.getFullYear(),t.getMonth()+1,t.getDate()))}for(const n of o){const o=`\n        SELECT buy_bot_id, sell_bot_id, price, amount\n        FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_trades\n        WHERE market_id = ? AND trade_date = ?\n      `,i=await client_1.default.execute(o,[cassandra_driver_1.types.Uuid.fromString(e),n],{prepare:!0});for(const e of i.rows){const o=null===(t=e.buy_bot_id)||void 0===t?void 0:t.toString();if(o){const t=a.get(o)||{tradeCount:0,totalVolume:0};t.tradeCount++;t.totalVolume+=Number(toBigIntSafe(e.amount))/1e18;a.set(o,t)}const n=null===(r=e.sell_bot_id)||void 0===r?void 0:r.toString();if(n){const t=a.get(n)||{tradeCount:0,totalVolume:0};t.tradeCount++;t.totalVolume+=Number(toBigIntSafe(e.amount))/1e18;a.set(n,t)}}}}catch(t){console_1.logger.error("AI_MM",`Failed to get bot trade stats for market ${e}: ${t}`)}return a}async function debugGetAllTrades(e=50){try{const t=`\n      SELECT market_id, trade_date, trade_time, buy_bot_id, sell_bot_id, price, amount\n      FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_trades\n      LIMIT ?\n      ALLOW FILTERING\n    `;return(await client_1.default.execute(t,[e],{prepare:!0})).rows.map(e=>{var t,r,a,o,n,i;return{marketId:null===(t=e.market_id)||void 0===t?void 0:t.toString(),tradeDate:null===(r=e.trade_date)||void 0===r?void 0:r.toString(),tradeTime:e.trade_time,buyBotId:null===(a=e.buy_bot_id)||void 0===a?void 0:a.toString(),sellBotId:null===(o=e.sell_bot_id)||void 0===o?void 0:o.toString(),price:null===(n=e.price)||void 0===n?void 0:n.toString(),amount:null===(i=e.amount)||void 0===i?void 0:i.toString()}})}catch(e){console_1.logger.error("AI_MM",`DEBUG: Failed to get all trades: ${e}`);return[]}}async function getRecentBotTrades(e,t=20){var r,a,o;const n=[];try{const i=[];for(let e=0;e<7;e++){const t=new Date;t.setDate(t.getDate()-e);i.push(new cassandra_driver_1.types.LocalDate(t.getFullYear(),t.getMonth()+1,t.getDate()))}for(const s of i){if(n.length>=t)break;const i=`\n        SELECT trade_id, trade_time, buy_bot_id, sell_bot_id, price, amount\n        FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_trades\n        WHERE market_id = ? AND trade_date = ?\n        ORDER BY trade_time DESC\n        LIMIT ?\n      `,d=await client_1.default.execute(i,[cassandra_driver_1.types.Uuid.fromString(e),s,t-n.length],{prepare:!0});for(const e of d.rows)n.push({id:(null===(r=e.trade_id)||void 0===r?void 0:r.toString())||"",price:(Number(toBigIntSafe(e.price))/1e18).toFixed(8),amount:(Number(toBigIntSafe(e.amount))/1e18).toFixed(8),buyBotId:(null===(a=e.buy_bot_id)||void 0===a?void 0:a.toString())||"",sellBotId:(null===(o=e.sell_bot_id)||void 0===o?void 0:o.toString())||"",createdAt:e.trade_time})}n.sort((e,t)=>new Date(t.createdAt).getTime()-new Date(e.createdAt).getTime());return n.slice(0,t)}catch(t){console_1.logger.error("AI_MM",`Failed to get recent bot trades for market ${e}: ${t}`);return[]}}async function getMarketTradeStats(e){let t=0,r=0;try{const a=[];for(let e=0;e<7;e++){const t=new Date;t.setDate(t.getDate()-e);a.push(new cassandra_driver_1.types.LocalDate(t.getFullYear(),t.getMonth()+1,t.getDate()))}for(const o of a){const a=`\n        SELECT price, amount\n        FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_trades\n        WHERE market_id = ? AND trade_date = ?\n      `,n=await client_1.default.execute(a,[cassandra_driver_1.types.Uuid.fromString(e),o],{prepare:!0});for(const e of n.rows){t++;r+=Number(toBigIntSafe(e.amount))/1e18}}}catch(t){console_1.logger.error("AI_MM",`Failed to get market trade stats for ${e}: ${t}`)}return{tradeCount:t,totalVolume:r}}async function deleteAiBotOrdersByMarket(e){let t=0;try{const r=`\n      SELECT order_id, created_at FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_orders\n      WHERE market_id = ?\n    `,a=await client_1.default.execute(r,[cassandra_driver_1.types.Uuid.fromString(e)],{prepare:!0});for(const r of a.rows){const a=`\n        DELETE FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_orders\n        WHERE market_id = ? AND created_at = ? AND order_id = ?\n      `;await client_1.default.execute(a,[cassandra_driver_1.types.Uuid.fromString(e),r.created_at,r.order_id],{prepare:!0});t++}console_1.logger.info("AI_MM",`Cleanup: Deleted ${t} bot orders for market ${e}`)}catch(t){console_1.logger.error("AI_MM",`Cleanup: Failed to delete bot orders for market ${e}: ${t}`)}return t}async function deleteAiBotTradesByMarket(e){let t=0;try{const r=[];for(let e=0;e<365;e++){const t=new Date;t.setDate(t.getDate()-e);r.push(new cassandra_driver_1.types.LocalDate(t.getFullYear(),t.getMonth()+1,t.getDate()))}for(const a of r){const r=`\n        SELECT trade_time, trade_id FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_trades\n        WHERE market_id = ? AND trade_date = ?\n      `,o=await client_1.default.execute(r,[cassandra_driver_1.types.Uuid.fromString(e),a],{prepare:!0});for(const r of o.rows){const o=`\n          DELETE FROM ${client_1.aiMarketMakerKeyspace}.ai_bot_trades\n          WHERE market_id = ? AND trade_date = ? AND trade_time = ? AND trade_id = ?\n        `;await client_1.default.execute(o,[cassandra_driver_1.types.Uuid.fromString(e),a,r.trade_time,r.trade_id],{prepare:!0});t++}}console_1.logger.info("AI_MM",`Cleanup: Deleted ${t} bot trades for market ${e}`)}catch(t){console_1.logger.error("AI_MM",`Cleanup: Failed to delete bot trades for market ${e}: ${t}`)}return t}async function deleteAiPriceHistoryByMarket(e){let t=0;try{const r=`\n      SELECT timestamp FROM ${client_1.aiMarketMakerKeyspace}.ai_price_history\n      WHERE market_id = ?\n    `,a=await client_1.default.execute(r,[cassandra_driver_1.types.Uuid.fromString(e)],{prepare:!0});for(const r of a.rows){const a=`\n        DELETE FROM ${client_1.aiMarketMakerKeyspace}.ai_price_history\n        WHERE market_id = ? AND timestamp = ?\n      `;await client_1.default.execute(a,[cassandra_driver_1.types.Uuid.fromString(e),r.timestamp],{prepare:!0});t++}console_1.logger.info("AI_MM",`Cleanup: Deleted ${t} price history entries for market ${e}`)}catch(t){console_1.logger.error("AI_MM",`Cleanup: Failed to delete price history for market ${e}: ${t}`)}return t}async function deleteRealLiquidityOrdersBySymbol(e){let t=0;try{const r=`\n      SELECT ai_order_id, ecosystem_order_id FROM ${client_1.aiMarketMakerKeyspace}.ai_real_liquidity_orders\n      WHERE symbol = ?\n      ALLOW FILTERING\n    `,a=await client_1.default.execute(r,[e],{prepare:!0});for(const e of a.rows){const r=`\n        DELETE FROM ${client_1.aiMarketMakerKeyspace}.ai_real_liquidity_orders\n        WHERE ecosystem_order_id = ?\n      `;await client_1.default.execute(r,[e.ecosystem_order_id],{prepare:!0});t++}console_1.logger.info("AI_MM",`Cleanup: Deleted ${t} real liquidity order records for ${e}`)}catch(t){console_1.logger.error("AI_MM",`Cleanup: Failed to delete real liquidity orders for ${e}: ${t}`)}return t}async function getOpenBotEcosystemOrderIds(e){const t=[];try{const r=`\n      SELECT ecosystem_order_id FROM ${client_1.aiMarketMakerKeyspace}.ai_real_liquidity_orders\n      WHERE symbol = ? AND status = 'OPEN'\n      ALLOW FILTERING\n    `,a=await client_1.default.execute(r,[e],{prepare:!0});for(const e of a.rows)e.ecosystem_order_id&&t.push(e.ecosystem_order_id.toString());console_1.logger.info("AI_MM",`Cleanup: Found ${t.length} open bot orders for ${e}`)}catch(t){console_1.logger.error("AI_MM",`Cleanup: Failed to get open bot orders for ${e}: ${t}`)}return t}async function cleanupMarketMakerData(e,t){console_1.logger.info("AI_MM",`Cleanup: Starting cleanup for market ${e} (${t})`);const r=await deleteAiBotOrdersByMarket(e),a=await deleteAiBotTradesByMarket(e),o=await deleteAiPriceHistoryByMarket(e),n=await deleteRealLiquidityOrdersBySymbol(t),i=await forceCleanOrderbook(t);console_1.logger.info("AI_MM",`Cleanup: Completed cleanup for ${t}: orders=${r}, trades=${a}, priceHistory=${o}, realLiquidityOrders=${n}, orderbookEntries=${i}`);return{ordersDeleted:r,tradesDeleted:a,priceHistoryDeleted:o,realLiquidityOrdersDeleted:n,orderbookEntriesCleared:i}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var o=Object.getOwnPropertyDescriptor(t,r);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,a,o)}:function(e,t,r,a){void 0===a&&(a=r);e[a]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var a=e(t),o=0;o<a.length;o++)"default"!==a[o]&&__createBinding(r,t,a[o]);__setModuleDefault(r,t);return r}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.insertBotOrder=insertBotOrder;exports.updateBotOrder=updateBotOrder;exports.getBotOrdersByMarket=getBotOrdersByMarket;exports.getBotOrdersByBot=getBotOrdersByBot;exports.getOpenBotOrders=getOpenBotOrders;exports.cancelBotOrder=cancelBotOrder;exports.insertBotTrade=insertBotTrade;exports.getBotTradesByMarket=getBotTradesByMarket;exports.getBotTradesInRange=getBotTradesInRange;exports.getDailyTradeVolume=getDailyTradeVolume;exports.insertPriceHistory=insertPriceHistory;exports.getPriceHistory=getPriceHistory;exports.getPriceHistoryInRange=getPriceHistoryInRange;exports.getLatestPrice=getLatestPrice;exports.calculateVolatility=calculateVolatility;exports.placeRealOrder=placeRealOrder;exports.cancelRealOrder=cancelRealOrder;exports.syncOrderbookFromAiTrade=syncOrderbookFromAiTrade;exports.syncTradeToEcosystem=syncTradeToEcosystem;exports.clearCandlesForSymbol=clearCandlesForSymbol;exports.clearOrderbookForSymbol=clearOrderbookForSymbol;exports.forceCleanOrderbook=forceCleanOrderbook;exports.getLastCandleClosePrice=getLastCandleClosePrice;exports.syncCandlesFromAiTrade=syncCandlesFromAiTrade;exports.getRealLiquidityOrdersBySymbol=getRealLiquidityOrdersBySymbol;exports.calculateLiquiditySplit=calculateLiquiditySplit;exports.getBotTradeStats=getBotTradeStats;exports.debugGetAllTrades=debugGetAllTrades;exports.getRecentBotTrades=getRecentBotTrades;exports.getMarketTradeStats=getMarketTradeStats;exports.deleteAiBotOrdersByMarket=deleteAiBotOrdersByMarket;exports.deleteAiBotTradesByMarket=deleteAiBotTradesByMarket;exports.deleteAiPriceHistoryByMarket=deleteAiPriceHistoryByMarket;exports.deleteRealLiquidityOrdersBySymbol=deleteRealLiquidityOrdersBySymbol;exports.getOpenBotEcosystemOrderIds=getOpenBotEcosystemOrderIds;exports.cleanupMarketMakerData=cleanupMarketMakerData;const client_1=__importStar(require("./client")),passwords_1=require("@b/utils/passwords"),cassandra_driver_1=require("cassandra-driver"),console_1=require("@b/utils/console"),queries_1=require("@b/api/(ext)/ecosystem/utils/scylla/queries"),orderbookUpdateLocks=new Map,intervalDurations={"1m":6e4,"3m":18e4,"5m":3e5,"15m":9e5,"30m":18e5,"1h":36e5,"2h":72e5,"4h":144e5,"6h":216e5,"12h":432e5,"1d":864e5,"3d":2592e5,"1w":6048e5};