"use strict";function createErrorResponse(e,r,t){return{error:!0,message:e,code:r,details:t,timestamp:(new Date).toISOString()}}Object.defineProperty(exports,"__esModule",{value:!0});exports.AIMarketMakerHttpStatus=exports.AIMarketMakerErrors=void 0;exports.createErrorResponse=createErrorResponse;exports.AIMarketMakerErrors={NOT_FOUND:e=>`AI Market Maker with ID ${e} not found`,POOL_NOT_FOUND:e=>`Pool not found for market maker ${e}`,BOT_NOT_FOUND:e=>`Bot with ID ${e} not found`,MARKET_NOT_FOUND:e=>`Ecosystem market with ID ${e} not found`,INVALID_PRICE_RANGE:()=>"Price range low must be less than price range high",TARGET_PRICE_OUT_OF_RANGE:()=>"Target price must be within the specified price range",INVALID_AMOUNT:e=>`${e} must be a positive number`,INVALID_PERCENTAGE:e=>`${e} must be between 0 and 100`,INSUFFICIENT_BALANCE:(e,r,t)=>`Insufficient ${t} balance. Available: ${e.toFixed(8)}, Requested: ${r.toFixed(8)}`,INSUFFICIENT_POOL_BALANCE:(e,r,t)=>`Insufficient pool ${t} balance. Available: ${e.toFixed(8)}, Requested: ${r.toFixed(8)}`,MARKET_ACTIVE:e=>`Cannot ${e} while market maker is active. Please stop the market maker first.`,MARKET_NOT_ACTIVE:()=>"Market maker is not active",MARKET_ALREADY_EXISTS:e=>`An AI Market Maker already exists for market ${e}`,MIN_BOTS_REQUIRED:(e,r)=>`At least ${e} bots are required, currently have ${r}`,BOT_LIMIT_REACHED:e=>`Maximum number of bots (${e}) reached for this market maker`,BOT_DAILY_LIMIT:e=>`Bot "${e}" has reached its daily trade limit`,ENGINE_NOT_RUNNING:()=>"AI Market Maker engine is not running",ENGINE_START_FAILED:e=>`Failed to start market maker engine: ${e}`,ENGINE_STOP_FAILED:e=>`Failed to stop market maker engine: ${e}`,ORDER_CANCELLATION_FAILED:e=>`Failed to cancel order ${e}`,ORDER_PLACEMENT_FAILED:e=>`Failed to place order: ${e}`,INVALID_CONFIG:(e,r)=>`Invalid configuration for ${e}: ${r}`,OPERATION_FAILED:(e,r)=>`${e} failed: ${r}`,INTERNAL_ERROR:()=>"An internal error occurred. Please try again later."};exports.AIMarketMakerHttpStatus={NOT_FOUND:404,INVALID_REQUEST:400,INSUFFICIENT_BALANCE:402,FORBIDDEN:403,CONFLICT:409,INTERNAL_ERROR:500};