"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.VolatilityMonitor=void 0;const queries_1=require("../../scylla/queries");class VolatilityMonitor{constructor(){this.volatilityCache=new Map;this.globalVolatility=0;this.cacheTtlMs=3e4}async getVolatility(t,i=60){const l=this.volatilityCache.get(t);if(l&&Date.now()-l.timestamp.getTime()<this.cacheTtlMs)return l.value;try{const l=await(0,queries_1.calculateVolatility)(t,i);this.volatilityCache.set(t,{value:l,timestamp:new Date});this.updateGlobalVolatility();return l}catch(t){return(null==l?void 0:l.value)||0}}getGlobalVolatility(){return this.globalVolatility}async isVolatilityHigh(t,i){return await this.getVolatility(t)>i}async getMultiTimeframeVolatility(t){const[i,l,a,e]=await Promise.all([(0,queries_1.calculateVolatility)(t,1),(0,queries_1.calculateVolatility)(t,5),(0,queries_1.calculateVolatility)(t,15),(0,queries_1.calculateVolatility)(t,60)]);return{min1:i,min5:l,min15:a,hour1:e}}updateGlobalVolatility(){if(0===this.volatilityCache.size){this.globalVolatility=0;return}let t=0,i=0;for(const[,l]of this.volatilityCache)if(Date.now()-l.timestamp.getTime()<2*this.cacheTtlMs){t+=l.value;i++}this.globalVolatility=i>0?t/i:0}clearCache(t){t?this.volatilityCache.delete(t):this.volatilityCache.clear();this.updateGlobalVolatility()}}exports.VolatilityMonitor=VolatilityMonitor;exports.default=VolatilityMonitor;