"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.RiskManager=void 0;const console_1=require("@b/utils/console"),VolatilityMonitor_1=require("./VolatilityMonitor"),LossProtection_1=require("./LossProtection"),CircuitBreaker_1=require("./CircuitBreaker"),cache_1=require("@b/utils/cache");class RiskManager{constructor(e){this.globalSettings=null;this.lastSettingsLoad=null;this.settingsRefreshIntervalMs=6e4;this.engine=e;this.volatilityMonitor=new VolatilityMonitor_1.VolatilityMonitor;this.lossProtection=new LossProtection_1.LossProtection;this.circuitBreaker=new CircuitBreaker_1.CircuitBreaker}async checkGlobalRisk(){var e,t,i,a;try{await this.refreshSettings();if(this.globalSettings&&!this.globalSettings.tradingEnabled)return{canTrade:!1,reason:"Trading is disabled globally",riskLevel:"CRITICAL"};if(null===(e=this.globalSettings)||void 0===e?void 0:e.maintenanceMode)return{canTrade:!1,reason:"System is in maintenance mode",riskLevel:"CRITICAL"};if(null===(t=this.globalSettings)||void 0===t?void 0:t.globalPauseEnabled)return{canTrade:!1,reason:"Global pause is enabled",riskLevel:"HIGH"};if(this.circuitBreaker.isTripped())return{canTrade:!1,reason:this.circuitBreaker.getTripReason(),riskLevel:"CRITICAL"};if(!1!==(null===(i=this.globalSettings)||void 0===i?void 0:i.stopLossEnabled)){const e=await this.lossProtection.checkGlobalLoss((null===(a=this.globalSettings)||void 0===a?void 0:a.maxDailyLossPercent)||10);if(!e.canTrade)return{canTrade:!1,reason:e.reason,riskLevel:"HIGH"}}return{canTrade:!0,riskLevel:this.calculateOverallRiskLevel()}}catch(e){console_1.logger.error("RISK_MANAGER","Risk check failed",e);return{canTrade:!1,reason:"Risk check failed",riskLevel:"HIGH"}}}async assessTradeRisk(e,t,i,a){var s;try{const t=await this.volatilityMonitor.getVolatility(e),a=(null===(s=this.globalSettings)||void 0===s?void 0:s.defaultVolatilityThreshold)||5;if(t>2*a)return{approved:!1,reason:`Extreme volatility: ${t.toFixed(2)}%`};if(t>a){const e=Math.max(.5,1-(t-a)/a);return{approved:!0,adjustedAmount:BigInt(Math.floor(Number(i)*e)),reason:`Reduced size due to volatility: ${t.toFixed(2)}%`}}const r=await this.lossProtection.getMarketLoss(e);return r>5?{approved:!1,reason:`Market loss limit exceeded: ${r.toFixed(2)}%`}:{approved:!0}}catch(e){console_1.logger.error("RISK_MANAGER","Trade assessment failed",e);return{approved:!1,reason:"Trade assessment failed"}}}async reportTradeResult(e,t,i){await this.lossProtection.recordTrade(e,t,i);if(i){this.lossProtection.getConsecutiveLosses(e)>=5&&this.circuitBreaker.trip(`5 consecutive losses on market ${e}`)}}tripCircuitBreaker(e){this.circuitBreaker.trip(e)}resetCircuitBreaker(){this.circuitBreaker.reset()}getRiskLevel(){return this.calculateOverallRiskLevel()}getStats(){return{riskLevel:this.calculateOverallRiskLevel(),circuitBreakerStatus:this.circuitBreaker.isTripped()?"TRIPPED":"OK",globalVolatility:this.volatilityMonitor.getGlobalVolatility(),globalLossPercent:this.lossProtection.getGlobalLossPercent()}}async refreshSettings(){if(!(this.lastSettingsLoad&&Date.now()-this.lastSettingsLoad.getTime()<this.settingsRefreshIntervalMs))try{const e=cache_1.CacheManager.getInstance(),[t,i,a,s,r,o]=await Promise.all([e.getSetting("aiMarketMakerEnabled"),e.getSetting("aiMarketMakerGlobalPauseEnabled"),e.getSetting("aiMarketMakerMaintenanceMode"),e.getSetting("aiMarketMakerMaxDailyLossPercent"),e.getSetting("aiMarketMakerDefaultVolatilityThreshold"),e.getSetting("aiMarketMakerStopLossEnabled")]);this.globalSettings={maxDailyLossPercent:parseFloat(s)||5,defaultVolatilityThreshold:parseFloat(r)||10,tradingEnabled:!1!==t,maintenanceMode:!0===a,globalPauseEnabled:!0===i,stopLossEnabled:!1!==o};this.lastSettingsLoad=new Date}catch(e){this.globalSettings||(this.globalSettings={maxDailyLossPercent:5,defaultVolatilityThreshold:10,tradingEnabled:!0,maintenanceMode:!1,globalPauseEnabled:!1,stopLossEnabled:!0})}}calculateOverallRiskLevel(){if(this.circuitBreaker.isTripped())return"CRITICAL";const e=this.lossProtection.getGlobalLossPercent(),t=this.volatilityMonitor.getGlobalVolatility();return e>8||t>15?"HIGH":e>4||t>8?"MEDIUM":"LOW"}}exports.RiskManager=RiskManager;exports.default=RiskManager;