"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.LossProtection=void 0;const db_1=require("@b/db");class LossProtection{constructor(){this.marketDailyLoss=new Map;this.consecutiveLosses=new Map;this.globalDailyLoss=0;this.globalDailyProfit=0;this.lastResetDate=new Date}async checkGlobalLoss(t){this.checkDayReset();const e=await this.getTotalCapital();if(e<=0)return{canTrade:!0};const s=this.globalDailyLoss/e*100;return s>=t?{canTrade:!1,reason:`Daily loss limit reached: ${s.toFixed(2)}% (max: ${t}%)`}:{canTrade:!0}}async getMarketLoss(t){this.checkDayReset();const e=this.marketDailyLoss.get(t)||0,s=await this.getMarketCapital(t);return s<=0?0:e/s*100}async recordTrade(t,e,s){this.checkDayReset();if(s){const s=this.marketDailyLoss.get(t)||0;this.marketDailyLoss.set(t,s+Math.abs(e));this.globalDailyLoss+=Math.abs(e);const a=this.consecutiveLosses.get(t)||0;this.consecutiveLosses.set(t,a+1)}else{this.globalDailyProfit+=e;this.consecutiveLosses.set(t,0)}}getConsecutiveLosses(t){return this.consecutiveLosses.get(t)||0}getGlobalLossPercent(){const t=this.globalDailyProfit-this.globalDailyLoss;return t<0?Math.abs(t)/100:0}shouldStopTrading(t){return(this.consecutiveLosses.get(t)||0)>=5}resetDaily(){this.marketDailyLoss.clear();this.consecutiveLosses.clear();this.globalDailyLoss=0;this.globalDailyProfit=0;this.lastResetDate=new Date}checkDayReset(){const t=new Date;t.getDate()===this.lastResetDate.getDate()&&t.getMonth()===this.lastResetDate.getMonth()&&t.getFullYear()===this.lastResetDate.getFullYear()||this.resetDaily()}async getTotalCapital(){try{const t=await db_1.models.aiMarketMakerPool.findAll();let e=0;for(const s of t)e+=parseFloat(s.totalValueLocked)||0;return e}catch(t){return 0}}async getMarketCapital(t){try{const e=await db_1.models.aiMarketMaker.findOne({where:{marketId:t},include:[{model:db_1.models.aiMarketMakerPool,as:"pool"}]});return(null==e?void 0:e.pool)&&parseFloat(e.pool.totalValueLocked)||0}catch(t){return 0}}}exports.LossProtection=LossProtection;exports.default=LossProtection;