"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.PoolManager=void 0;const db_1=require("@b/db"),console_1=require("@b/utils/console"),BalanceTracker_1=require("./BalanceTracker"),PnLCalculator_1=require("./PnLCalculator");class PoolManager{constructor(){this.balanceTrackers=new Map;this.pnlCalculator=new PnLCalculator_1.PnLCalculator}getBalanceTracker(a){let e=this.balanceTrackers.get(a);if(!e){e=new BalanceTracker_1.BalanceTracker(a);this.balanceTrackers.set(a,e)}return e}async getBalance(a){return this.getBalanceTracker(a).getBalance()}async deposit(a,e,t){try{const r=this.getBalanceTracker(a);await r.deposit(e,t);await this.updatePoolInDatabase(a);await this.logPoolAction(a,"DEPOSIT",{currency:e,amount:t});return!0}catch(a){console_1.logger.error("AI_MM_POOL","Failed to deposit to pool",a);return!1}}async withdraw(a,e,t){try{const r=this.getBalanceTracker(a);if(!await r.canWithdraw(e,t)){console_1.logger.warn("AI_MM","Insufficient balance for withdrawal");return!1}await r.withdraw(e,t);await this.updatePoolInDatabase(a);await this.logPoolAction(a,"WITHDRAW",{currency:e,amount:t});return!0}catch(a){console_1.logger.error("AI_MM_POOL","Failed to withdraw from pool",a);return!1}}async canWithdraw(a,e,t){const r=this.getBalanceTracker(a),o=await db_1.models.aiMarketMaker.findByPk(a);return o&&"ACTIVE"===o.status?{allowed:!1,reason:"Cannot withdraw while market maker is active. Please pause first."}:await r.canWithdraw(e,t)?{allowed:!0}:{allowed:!1,reason:"Insufficient available balance"}}async rebalance(a,e){try{const t=this.getBalanceTracker(a);await t.rebalance(e);await this.updatePoolInDatabase(a);await this.logPoolAction(a,"REBALANCE",{targetRatio:e});return!0}catch(a){console_1.logger.error("AI_MM_POOL","Failed to rebalance pool",a);return!1}}async updateAllBalances(){for(const[a,e]of this.balanceTrackers)try{await e.syncFromDatabase();await this.pnlCalculator.calculatePnL(a,e)}catch(a){}}async getPnL(a){return this.pnlCalculator.getPnL(a)}async recordTradePnL(a,e,t){this.pnlCalculator.recordPnL(a,e,t)}async getAllPoolStats(){const a=new Map;for(const[e,t]of this.balanceTrackers)a.set(e,{balance:await t.getBalance(),pnl:await this.getPnL(e)});return a}async updatePoolInDatabase(a){try{const e=this.getBalanceTracker(a),t=await e.getBalance();await db_1.models.aiMarketMakerPool.update({baseCurrencyBalance:t.baseCurrency,quoteCurrencyBalance:t.quoteCurrency,totalValueLocked:t.totalValueLocked},{where:{marketMakerId:a}})}catch(a){console_1.logger.error("AI_MM_POOL","Failed to update pool in database",a)}}async logPoolAction(a,e,t){try{const r=this.getBalanceTracker(a),o=await r.getBalance();await db_1.models.aiMarketMakerHistory.create({marketMakerId:a,action:e,details:t,priceAtAction:0,poolValueAtAction:o.totalValueLocked})}catch(a){}}}exports.PoolManager=PoolManager;exports.default=PoolManager;