"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.BalanceTracker=void 0;const db_1=require("@b/db"),tvl_1=require("../../helpers/tvl"),error_1=require("@b/utils/error");class BalanceTracker{constructor(e){this.baseCurrencyBalance=0;this.quoteCurrencyBalance=0;this.reservedBase=0;this.reservedQuote=0;this.initialBaseBalance=0;this.initialQuoteBalance=0;this.lastSyncTime=null;this.currentPrice=0;this.marketMakerId=e}setCurrentPrice(e){this.currentPrice=e}async syncFromDatabase(){try{const e=await db_1.models.aiMarketMakerPool.findOne({where:{marketMakerId:this.marketMakerId}});if(e){this.baseCurrencyBalance=parseFloat(e.baseCurrencyBalance)||0;this.quoteCurrencyBalance=parseFloat(e.quoteCurrencyBalance)||0;this.initialBaseBalance=parseFloat(e.initialBaseBalance)||0;this.initialQuoteBalance=parseFloat(e.initialQuoteBalance)||0;this.lastSyncTime=new Date}}catch(e){}}async getBalance(){(!this.lastSyncTime||Date.now()-this.lastSyncTime.getTime()>6e4)&&await this.syncFromDatabase();const e=(0,tvl_1.calculateTVL)({baseBalance:this.baseCurrencyBalance,quoteBalance:this.quoteCurrencyBalance,currentPrice:this.currentPrice});return{baseCurrency:this.baseCurrencyBalance,quoteCurrency:this.quoteCurrencyBalance,totalValueLocked:e}}getAvailableBalance(){return{base:Math.max(0,this.baseCurrencyBalance-this.reservedBase),quote:Math.max(0,this.quoteCurrencyBalance-this.reservedQuote)}}reserve(e,a){const r=this.getAvailableBalance();if("base"===e){if(r.base<a)return!1;this.reservedBase+=a}else{if(r.quote<a)return!1;this.reservedQuote+=a}return!0}release(e,a){"base"===e?this.reservedBase=Math.max(0,this.reservedBase-a):this.reservedQuote=Math.max(0,this.reservedQuote-a)}async deposit(e,a){"base"===e?this.baseCurrencyBalance+=a:this.quoteCurrencyBalance+=a}async withdraw(e,a){const r=this.getAvailableBalance();if("base"===e){if(r.base<a)throw(0,error_1.createError)({statusCode:400,message:"Insufficient base currency balance"});this.baseCurrencyBalance-=a}else{if(r.quote<a)throw(0,error_1.createError)({statusCode:400,message:"Insufficient quote currency balance"});this.quoteCurrencyBalance-=a}}async canWithdraw(e,a){const r=this.getAvailableBalance();return"base"===e?r.base>=a:r.quote>=a}async rebalance(e=.5){const a=this.baseCurrencyBalance+this.quoteCurrencyBalance;this.baseCurrencyBalance=a*e;this.quoteCurrencyBalance=a*(1-e)}applyTrade(e,a,r,t=0){const s=a*r;if("BUY"===e){this.baseCurrencyBalance+=a;this.quoteCurrencyBalance-=s+t}else{this.baseCurrencyBalance-=a;this.quoteCurrencyBalance+=s-t}}getInitialBalances(){return{base:this.initialBaseBalance,quote:this.initialQuoteBalance}}getReserved(){return{base:this.reservedBase,quote:this.reservedQuote}}}exports.BalanceTracker=BalanceTracker;exports.default=BalanceTracker;