"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.OrderManager=void 0;const console_1=require("@b/utils/console"),queries_1=require("../scylla/queries"),AI_ORDER_EXPIRATION_MS=3e5,REAL_ORDER_EXPIRATION_MS=36e5;class OrderManager{constructor(e,r){this.openOrders=new Map;this.ordersCreated=0;this.ordersCanceled=0;this.ordersFilled=0;this.config=e;this.engine=r}async initialize(){try{if(this.config.realLiquidityPercent>0){const e=await(0,queries_1.getRealLiquidityOrdersBySymbol)(this.config.symbol,"OPEN");for(const r of e)this.trackOrder({orderId:r.ecosystemOrderId,botId:r.aiBotOrderId,side:r.side,price:r.price,amount:r.amount,filledAmount:BigInt(0),isRealLiquidity:!0,createdAt:r.createdAt,expiresAt:new Date(r.createdAt.getTime()+36e5)})}console_1.logger.debug("AI_MM",`OrderManager initialized with ${this.openOrders.size} real liquidity orders for ${this.config.symbol}`)}catch(e){console_1.logger.error("AI_MM","OrderManager initialization error",e);throw e}}async createOrder(e){try{return e.isRealLiquidity?this.createRealOrder(e):this.createAiOrder(e)}catch(e){console_1.logger.error("AI_MM","Order creation error",e);return null}}async createAiOrder(e){const r=await(0,queries_1.insertBotOrder)({marketId:this.config.marketId,botId:e.botId,side:e.side,type:e.type,price:e.price,amount:e.amount,filledAmount:BigInt(0),status:"OPEN",purpose:e.purpose}),t=new Date;this.trackOrder({orderId:r,botId:e.botId,side:e.side,price:e.price,amount:e.amount,filledAmount:BigInt(0),isRealLiquidity:!1,createdAt:t,expiresAt:new Date(t.getTime()+3e5)});this.ordersCreated++;return r}async createRealOrder(e){const r=await(0,queries_1.insertBotOrder)({marketId:this.config.marketId,botId:e.botId,side:e.side,type:e.type,price:e.price,amount:e.amount,filledAmount:BigInt(0),status:"OPEN",purpose:e.purpose}),t=await(0,queries_1.placeRealOrder)(this.config.symbol,e.side,e.price,e.amount,r,this.config.id,e.botId),i=new Date;this.trackOrder({orderId:t.id,botId:e.botId,side:e.side,price:e.price,amount:e.amount,filledAmount:BigInt(0),isRealLiquidity:!0,createdAt:i,expiresAt:new Date(i.getTime()+36e5)});this.ordersCreated++;return t.id}async cancelOrder(e){try{const r=this.openOrders.get(e);if(!r)return!1;r.isRealLiquidity?await(0,queries_1.cancelRealOrder)(e,r.botId,r.createdAt.toISOString(),this.config.symbol,r.price,r.side,r.amount-r.filledAmount):await(0,queries_1.cancelBotOrder)(this.config.marketId,e,r.createdAt);this.openOrders.delete(e);this.ordersCanceled++;return!0}catch(e){console_1.logger.error("AI_MM","Order cancellation error",e);return!1}}async cancelAllOrders(){const e=Array.from(this.openOrders.keys());await Promise.all(e.map(e=>this.cancelOrder(e)));this.openOrders.clear()}async cleanupExpiredOrders(){const e=new Date,r=[];for(const[t,i]of this.openOrders)i.expiresAt<=e&&r.push(t);if(0===r.length)return;let t=0,i=0;for(const e of r){const r=this.openOrders.get(e);if(r){try{r.isRealLiquidity?await(0,queries_1.cancelRealOrder)(e,r.botId,r.createdAt.toISOString(),this.config.symbol,r.price,r.side,r.amount-r.filledAmount):await(0,queries_1.cancelBotOrder)(this.config.marketId,e,r.createdAt);t++}catch(e){i++}this.openOrders.delete(e);this.ordersCanceled++}}console_1.logger.debug("AI_MM",`Cleaned up ${r.length} expired orders for ${this.config.symbol} (cancelled: ${t}, already processed: ${i})`)}async updateOrderFill(e,r,t){const i=this.openOrders.get(e);if(i){i.isRealLiquidity||await(0,queries_1.updateBotOrder)(this.config.marketId,e,i.createdAt,{filledAmount:r,status:t});i.filledAmount=r;if("FILLED"===t){this.openOrders.delete(e);this.ordersFilled++}}}findMatchingOrders(e,r,t){const i="BUY"===e?"SELL":"BUY",s=[];let o=t;for(const[,t]of this.openOrders){if(t.isRealLiquidity)continue;if(t.side!==i)continue;if("BUY"===e&&t.price>r)continue;if("SELL"===e&&t.price<r)continue;const d=t.amount-t.filledAmount;if(!(d<=BigInt(0))){s.push(t);o-=d;if(o<=BigInt(0))break}}return s}getOpenOrderCount(){return this.openOrders.size}getOrderCounts(){let e=0,r=0;for(const[,t]of this.openOrders)"BUY"===t.side?e++:r++;return{buys:e,sells:r}}getStats(){return{openOrders:this.openOrders.size,ordersCreated:this.ordersCreated,ordersCanceled:this.ordersCanceled,ordersFilled:this.ordersFilled}}trackOrder(e){this.openOrders.set(e.orderId,e)}getOpenOrders(){return Array.from(this.openOrders.values())}}exports.OrderManager=OrderManager;exports.default=OrderManager;