"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.SwingBot=void 0;const BaseBot_1=require("../BaseBot");class SwingBot extends BaseBot_1.BaseBot{constructor(e){super({...e,personality:"SWING",tradeFrequency:"MEDIUM"});this.minSwingPercent=.5;this.maxSwingPercent=3;this.holdTimeMs=3e5;this.currentPosition="NEUTRAL";this.entryPrice=0;this.positionOpenTime=null}decideTrade(e){if(!this.canTrade())return{shouldTrade:!1,reason:"Cannot trade"};const t=Number(e.currentPrice)/1e18,i=(Number(e.targetPrice)/1e18-t)/t*100;return"NEUTRAL"!==this.currentPosition?this.managePosition(e,t,i):this.findEntry(e,t,i)}managePosition(e,t,i){if(!this.positionOpenTime){this.currentPosition="NEUTRAL";return{shouldTrade:!1}}const r=Date.now()-this.positionOpenTime.getTime(),n=(t-this.entryPrice)/this.entryPrice*100,o=this.minSwingPercent+Math.random()*(this.maxSwingPercent-this.minSwingPercent);if("LONG"===this.currentPosition&&n>=o||"SHORT"===this.currentPosition&&n<=-o||r>2*this.holdTimeMs||Math.abs(i)>this.maxSwingPercent){const t="LONG"===this.currentPosition?"SELL":"BUY",i=this.calculatePrice(e,t),r=this.calculateOrderSize(e);this.currentPosition="NEUTRAL";this.entryPrice=0;this.positionOpenTime=null;return{shouldTrade:!0,side:t,price:i,amount:r,purpose:"PRICE_PUSH",confidence:.8,reason:`Closing ${this.currentPosition} position (${n.toFixed(2)}% P&L)`}}return{shouldTrade:!1,reason:"Holding position"}}findEntry(e,t,i){if(Math.abs(i)<this.minSwingPercent)return{shouldTrade:!1,reason:"Price too close to target"};if(e.volatility>5)return{shouldTrade:!1,reason:"Volatility too high for swing entry"};const r=t<=1.02*e.priceRangeLow,n=t>=.98*e.priceRangeHigh;let o,s;if(r&&i>0){o="BUY";s="Long entry near support"}else if(n&&i<0){o="SELL";s="Short entry near resistance"}else if(i>this.minSwingPercent){o="BUY";s="Long entry to push price up"}else{o="SELL";s="Short entry to push price down"}if(Math.random()>.4)return{shouldTrade:!1,reason:"Waiting for better entry"};const a=this.calculatePrice(e,o),c=this.calculateOrderSize(e);this.currentPosition="BUY"===o?"LONG":"SHORT";this.entryPrice=t;this.positionOpenTime=new Date;return{shouldTrade:!0,side:o,price:a,amount:c,purpose:"PRICE_PUSH",confidence:.6+.1*Math.abs(i),reason:s}}calculateOrderSize(e){const t=this.config.avgOrderSize,i=this.addVariance(t,.3);return BigInt(Math.floor(1e18*i))}calculatePrice(e,t){const i=Number(e.currentPrice)/1e18,r=.001+.003*Math.random();let n;n="BUY"===t?i*(1-r):i*(1+r);return BigInt(Math.floor(1e18*n))}getCooldownTime(){return 6e4}}exports.SwingBot=SwingBot;exports.default=SwingBot;