"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.HumanSimulator=void 0;const TimingGenerator_1=require("./TimingGenerator"),SizeGenerator_1=require("./SizeGenerator"),PriceGenerator_1=require("./PriceGenerator");class HumanSimulator{constructor(t,e={}){this.emotionalState={fear:.3,greed:.3,confidence:.5,frustration:.2};this.recentTrades=[];this.traits={patience:.5,riskTolerance:.5,precision:.5,consistency:.5,emotionality:.5,...e};this.timingGenerator=new TimingGenerator_1.TimingGenerator(this.calculateBaseDelay(),this.calculateMaxDelay());this.sizeGenerator=new SizeGenerator_1.SizeGenerator(t,.1*t,5*t);this.priceGenerator=new PriceGenerator_1.PriceGenerator}generateOrder(t,e,a,i={}){const{urgency:r=.5,marketVolatility:n=.3,recentVolume:o=1,nearSupport:s,nearResistance:h}=i,l=this.calculateEmotionalUrgency(r),c=this.calculateEmotionalConfidence(),m=this.generateDelay(l),S=this.generateSize(a,c,n),u=this.generatePrice(t,e,l,"BUY"===t?s:h),d=this.shouldSplitOrder(S,a,c);return{price:u,size:S,delay:m,shouldSplit:d,splitCount:d?this.calculateSplitCount(S,a):void 0,urgency:l,confidence:c}}processMarketEvent(t,e=.5){const a=e*this.traits.emotionality;switch(t){case"PRICE_SPIKE_UP":this.emotionalState.greed+=.3*a;this.emotionalState.fear-=.1*a;break;case"PRICE_SPIKE_DOWN":this.emotionalState.fear+=.3*a;this.emotionalState.greed-=.1*a;break;case"HIGH_VOLUME":this.emotionalState.confidence+=.2*a;break;case"LOW_VOLUME":this.emotionalState.confidence-=.2*a;break;case"SPREAD_WIDENING":this.emotionalState.fear+=.2*a;this.emotionalState.frustration+=.1*a;break;case"TREND_REVERSAL":this.emotionalState.fear+=.2*a;this.emotionalState.confidence-=.2*a;break;case"BREAKOUT":this.emotionalState.greed+=.2*a;this.emotionalState.confidence+=.1*a;break;case"RANGE_BOUND":this.emotionalState.frustration+=.1*a}this.normalizeEmotions();this.decayEmotions()}recordTradeResult(t,e,a){this.recentTrades.push({side:t,success:e,pnl:a,timestamp:Date.now()});this.recentTrades.length>50&&this.recentTrades.shift();if(e&&a>0){this.emotionalState.confidence+=.05*this.traits.emotionality;this.emotionalState.greed+=.03*this.traits.emotionality}else{this.emotionalState.fear+=.05*this.traits.emotionality;this.emotionalState.frustration+=.03*this.traits.emotionality}this.normalizeEmotions();this.sizeGenerator.recordTrade(Math.abs(a),t)}wouldTradeNow(){if(!this.timingGenerator.isGoodTimeToTrade())return Math.random()<.1;if(this.emotionalState.fear>.7)return Math.random()<.3;if(this.emotionalState.frustration>.8)return Math.random()<.2;const t=.5+.3*(1-this.traits.patience);return Math.random()<t}getEmotionalState(){return{...this.emotionalState}}getTraits(){return{...this.traits}}getRecentWinRate(){if(0===this.recentTrades.length)return.5;return this.recentTrades.filter(t=>t.success).length/this.recentTrades.length}resetEmotions(){this.emotionalState={fear:.3,greed:.3,confidence:.5,frustration:.2};this.timingGenerator.resetSession()}calculateBaseDelay(){return 1e3*(.5+this.traits.patience)}calculateMaxDelay(){return 10*this.calculateBaseDelay()}generateDelay(t){const e=this.timingGenerator.getNextDelay(),a=1-.5*t;let i=1;this.emotionalState.fear>.6&&(i=Math.random()<.5?.5:2);const r=1-.3*this.emotionalState.greed;return Math.floor(e*a*i*r)}generateSize(t,e,a){let i=this.sizeGenerator.generateSize({confidence:e,urgency:this.emotionalState.greed,preferRound:this.traits.precision<.5});i*=.7+.6*this.traits.riskTolerance;i*=1-.3*this.emotionalState.fear;i*=1+.2*this.emotionalState.greed;a>.5&&this.traits.riskTolerance<.5&&(i*=.7);return Math.max(.1*t,i)}generatePrice(t,e,a,i){const r=this.traits.precision<.5;return"BUY"===t?this.priceGenerator.generateBuyPrice(e,{aggressiveness:a*(1+.5*this.emotionalState.greed),preferPsychological:r,nearSupport:i}):this.priceGenerator.generateSellPrice(e,{aggressiveness:a*(1+.5*this.emotionalState.fear),preferPsychological:r,nearResistance:i})}shouldSplitOrder(t,e,a){return t>3*e?Math.random()<.7:a<.3?Math.random()<.5:this.traits.patience>.7?Math.random()<.4:Math.random()<.2}calculateSplitCount(t,e){const a=t/e;return a>5?Math.floor(3+3*Math.random()):a>3?Math.floor(2+2*Math.random()):2}calculateEmotionalUrgency(t){let e=t;e+=.2*this.emotionalState.greed;this.emotionalState.fear>.5&&(e+=.4*(Math.random()-.5));e+=.15*this.emotionalState.frustration;return Math.max(0,Math.min(1,e))}calculateEmotionalConfidence(){let t=this.emotionalState.confidence;t=.7*t+.3*this.getRecentWinRate();t-=.3*this.emotionalState.fear;t+=.1*this.emotionalState.greed;return Math.max(0,Math.min(1,t))}normalizeEmotions(){this.emotionalState.fear=Math.max(0,Math.min(1,this.emotionalState.fear));this.emotionalState.greed=Math.max(0,Math.min(1,this.emotionalState.greed));this.emotionalState.confidence=Math.max(0,Math.min(1,this.emotionalState.confidence));this.emotionalState.frustration=Math.max(0,Math.min(1,this.emotionalState.frustration))}decayEmotions(){const t=.95,e=.3;this.emotionalState.fear=e+(this.emotionalState.fear-e)*t;this.emotionalState.greed=e+(this.emotionalState.greed-e)*t;this.emotionalState.confidence=.5+(this.emotionalState.confidence-.5)*t;this.emotionalState.frustration=.2+(this.emotionalState.frustration-.2)*t}getStats(){return{traits:this.traits,emotions:this.getEmotionalState(),recentTrades:this.recentTrades.length,winRate:this.getRecentWinRate(),timing:this.timingGenerator.getStats(),sizing:this.sizeGenerator.getStats(),pricing:this.priceGenerator.getStats()}}}exports.HumanSimulator=HumanSimulator;exports.default=HumanSimulator;