"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.BotFactory=void 0;const ScalperBot_1=require("./personalities/ScalperBot"),SwingBot_1=require("./personalities/SwingBot"),AccumulatorBot_1=require("./personalities/AccumulatorBot"),DistributorBot_1=require("./personalities/DistributorBot"),MarketMakerBot_1=require("./personalities/MarketMakerBot"),error_1=require("@b/utils/error"),DEFAULT_BOT_DISTRIBUTION=["SCALPER","SCALPER","SWING","ACCUMULATOR","DISTRIBUTOR","MARKET_MAKER"];class BotFactory{constructor(){this.botCounter=0}static getInstance(){BotFactory.instance||(BotFactory.instance=new BotFactory);return BotFactory.instance}createBot(e){switch(e.personality){case"SCALPER":return new ScalperBot_1.ScalperBot(e);case"SWING":return new SwingBot_1.SwingBot(e);case"ACCUMULATOR":return new AccumulatorBot_1.AccumulatorBot(e);case"DISTRIBUTOR":return new DistributorBot_1.DistributorBot(e);case"MARKET_MAKER":return new MarketMakerBot_1.MarketMakerBot(e);default:throw(0,error_1.createError)({statusCode:400,message:`Unknown bot personality: ${e.personality}`})}}createBotsForMarket(e){var t;const r=e.personalities||DEFAULT_BOT_DISTRIBUTION,a=[],s=this.calculateBalanceDistribution(r);for(let o=0;o<r.length;o++){const i=r[o],n=s[i],c=(null===(t=e.customBotConfigs)||void 0===t?void 0:t[o])||{},u={id:this.generateBotId(e.marketId,i),name:`${i}-${e.symbol}-${o+1}`,marketMakerId:e.marketId,personality:i,riskTolerance:this.getDefaultRiskTolerance(i),tradeFrequency:this.getDefaultFrequency(i),avgOrderSize:e.avgOrderSize*n.sizeMultiplier,orderSizeVariance:.2,preferredSpread:this.getDefaultSpread(i),maxDailyTrades:this.getDefaultMaxDailyTrades(i),...c},R=this.createBot(u);a.push(R)}return a}createBalancedBotSet(e){return this.createBotsForMarket({...e,personalities:["ACCUMULATOR","SWING","MARKET_MAKER","MARKET_MAKER","SWING","DISTRIBUTOR"]})}createAggressiveBotSet(e){return this.createBotsForMarket({...e,personalities:["SCALPER","SCALPER","SCALPER","MARKET_MAKER","MARKET_MAKER","SWING"]})}createConservativeBotSet(e){return this.createBotsForMarket({...e,personalities:["SWING","SWING","ACCUMULATOR","DISTRIBUTOR"]})}createSingleBot(e,t,r,a,s,o){const i={id:this.generateBotId(e,r),name:`${r}-${t}`,marketMakerId:e,personality:r,riskTolerance:this.getDefaultRiskTolerance(r),tradeFrequency:this.getDefaultFrequency(r),avgOrderSize:o,orderSizeVariance:.2,preferredSpread:this.getDefaultSpread(r),maxDailyTrades:this.getDefaultMaxDailyTrades(r)};return this.createBot(i)}generateBotId(e,t){this.botCounter++;const r=Date.now().toString(36),a=this.botCounter.toString(36).padStart(4,"0");return`${e}-${t.substring(0,3).toUpperCase()}-${r}-${a}`}getDefaultFrequency(e){switch(e){case"SCALPER":case"MARKET_MAKER":return"HIGH";case"SWING":default:return"MEDIUM";case"ACCUMULATOR":case"DISTRIBUTOR":return"LOW"}}getDefaultRiskTolerance(e){switch(e){case"SCALPER":return.3;case"SWING":default:return.5;case"ACCUMULATOR":case"DISTRIBUTOR":return.4;case"MARKET_MAKER":return.6}}getDefaultSpread(e){switch(e){case"SCALPER":return.001;case"SWING":return.005;case"ACCUMULATOR":case"DISTRIBUTOR":default:return.003;case"MARKET_MAKER":return.002}}getDefaultMaxDailyTrades(e){switch(e){case"SCALPER":return 200;case"SWING":return 20;case"ACCUMULATOR":case"DISTRIBUTOR":return 30;case"MARKET_MAKER":return 100;default:return 50}}calculateBalanceDistribution(e){const t={SCALPER:0,SWING:0,ACCUMULATOR:0,DISTRIBUTOR:0,MARKET_MAKER:0};for(const r of e)t[r]++;e.length;const r={SCALPER:{base:.1,quote:.1,size:.5},SWING:{base:.2,quote:.2,size:1},ACCUMULATOR:{base:.15,quote:.25,size:.8},DISTRIBUTOR:{base:.25,quote:.15,size:.8},MARKET_MAKER:{base:.2,quote:.2,size:.6}};let a=0,s=0;for(const t of e){a+=r[t].base;s+=r[t].quote}const o={SCALPER:{basePercent:0,quotePercent:0,sizeMultiplier:.5},SWING:{basePercent:0,quotePercent:0,sizeMultiplier:1},ACCUMULATOR:{basePercent:0,quotePercent:0,sizeMultiplier:.8},DISTRIBUTOR:{basePercent:0,quotePercent:0,sizeMultiplier:.8},MARKET_MAKER:{basePercent:0,quotePercent:0,sizeMultiplier:.6}};for(const e of Object.keys(r))t[e]>0&&(o[e]={basePercent:r[e].base/a/t[e],quotePercent:r[e].quote/s/t[e],sizeMultiplier:r[e].size});return o}getRecommendedBotCount(e){return e<1e4?3:e<1e5?5:e<1e6?8:12}getRecommendedPersonalities(e){switch(e){case"STABLE":return["MARKET_MAKER","MARKET_MAKER","SCALPER","ACCUMULATOR","DISTRIBUTOR"];case"VOLATILE":return["SCALPER","SCALPER","SCALPER","MARKET_MAKER","SWING"];case"TRENDING":return["SWING","SWING","ACCUMULATOR","DISTRIBUTOR","SCALPER"];default:return DEFAULT_BOT_DISTRIBUTION}}}exports.BotFactory=BotFactory;exports.default=BotFactory;