"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.BaseBot=void 0;const console_1=require("@b/utils/console");class BaseBot{constructor(t){this.status="STOPPED";this.orderManager=null;this.dailyTradeCount=0;this.lastTradeTime=null;this.openOrderIds=new Set;this.consecutiveWins=0;this.consecutiveLosses=0;this.totalTrades=0;this.winningTrades=0;this.totalPnL=0;this.config=t}initialize(t){this.orderManager=t;this.status="ACTIVE";this.resetDailyStats()}start(){if("STOPPED"===this.status){this.status="ACTIVE";this.resetDailyStats()}}stop(){this.status="STOPPED"}pause(){"ACTIVE"===this.status&&(this.status="PAUSED")}resume(){"PAUSED"===this.status&&(this.status="ACTIVE")}enterCooldown(){this.status="COOLDOWN";setTimeout(()=>{"COOLDOWN"===this.status&&(this.status="ACTIVE")},this.getCooldownTime())}canTrade(){if("ACTIVE"!==this.status)return!1;if(this.dailyTradeCount>=this.config.maxDailyTrades)return!1;if(this.lastTradeTime){const t=this.getMinTradeInterval();if(Date.now()-this.lastTradeTime.getTime()<t)return!1}return!0}async executeTrade(t){if(!this.orderManager||!t.shouldTrade)return null;if(!t.side||!t.price||!t.amount)return null;try{const e=await this.orderManager.createOrder({botId:this.config.id,side:t.side,type:"LIMIT",price:t.price,amount:t.amount,purpose:t.purpose||"LIQUIDITY",isRealLiquidity:!1});if(e){this.openOrderIds.add(e);this.dailyTradeCount++;this.totalTrades++;this.lastTradeTime=new Date}return e}catch(t){console_1.logger.error("AI_BOT","Failed to execute trade",t);return null}}async cancelOrder(t){if(!this.orderManager)return!1;const e=await this.orderManager.cancelOrder(t);e&&this.openOrderIds.delete(t);return e}async cancelAllOrders(){if(this.orderManager){for(const t of this.openOrderIds)await this.cancelOrder(t);this.openOrderIds.clear()}}recordTradeResult(t){this.totalPnL+=t;if(t>0){this.winningTrades++;this.consecutiveWins++;this.consecutiveLosses=0}else if(t<0){this.consecutiveLosses++;this.consecutiveWins=0;this.consecutiveLosses>=3&&this.enterCooldown()}}resetDailyStats(){this.dailyTradeCount=0}getId(){return this.config.id}getBotId(){return this.config.id}getName(){return this.config.name}getPersonality(){return this.config.personality}getStatus(){return this.status}getConfig(){return{...this.config}}getOpenOrderCount(){return this.openOrderIds.size}getTotalTrades(){return this.totalTrades}getSuccessfulTrades(){return this.winningTrades}getFailedTrades(){return this.totalTrades-this.winningTrades}getWinRate(){return this.totalTrades>0?this.winningTrades/this.totalTrades:0}getLastTradeTime(){return this.lastTradeTime?this.lastTradeTime.getTime():null}getPnL(){return this.totalPnL}setOrderManager(t){this.orderManager=t}getStats(){return{totalTrades:this.totalTrades,winningTrades:this.winningTrades,winRate:this.totalTrades>0?this.winningTrades/this.totalTrades:0,totalPnL:this.totalPnL,dailyTradeCount:this.dailyTradeCount,status:this.status}}getMinTradeInterval(){switch(this.config.tradeFrequency){case"HIGH":return 5e3;case"MEDIUM":return 3e4;case"LOW":return 12e4}}addVariance(t,e=this.config.orderSizeVariance){return t*(1-e+Math.random()*e*2)}isNearPsychologicalLevel(t){const e=[1e3*Math.floor(t/1e3),100*Math.floor(t/100),10*Math.floor(t/10)];for(const s of e){if(Math.abs(t-s)/t<.005)return!0}return!1}getTrendDirection(t,e){const s=(e-t)/t;return Math.abs(s)<.001?"SIDEWAYS":s>0?"UP":"DOWN"}}exports.BaseBot=BaseBot;exports.default=BaseBot;