"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),errors_1=require("@b/utils/schema/errors"),queries_1=require("../utils/scylla/queries"),matchingEngine_1=require("@b/api/(ext)/ecosystem/utils/matchingEngine"),cache_1=require("@b/utils/cache"),console_1=require("@b/utils/console");exports.metadata={summary:"Emergency stop all AI Market Maker operations",operationId:"emergencyStopAllMarketMakers",tags:["Admin","AI Market Maker","Emergency"],description:"Immediately stops all AI Market Maker operations across the platform. This emergency endpoint halts all active market makers, pauses all associated AI bots, disables the global AI Market Maker feature, and optionally cancels all open orders in the ecosystem. All actions are performed within a database transaction and logged to the market maker history. Manual intervention is required to resume operations after an emergency stop.",logModule:"ADMIN_MM",logTitle:"Emergency Stop All Operations",requestBody:{required:!1,content:{"application/json":{schema:{type:"object",properties:{reason:{type:"string",description:"Reason for emergency stop"},cancelOpenOrders:{type:"boolean",description:"Whether to cancel all open orders (default: true)"}}}}}},responses:{200:{description:"Emergency stop executed successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},marketsStopped:{type:"number"},botsStopped:{type:"number"},ordersCancelled:{type:"number"},reason:{type:"string"},timestamp:{type:"string"},warning:{type:"string"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"edit.ai.market-maker.emergency"};exports.default=async e=>{const{body:t,ctx:a}=e,r=(null==t?void 0:t.reason)||"Emergency stop triggered by admin",s=!1!==(null==t?void 0:t.cancelOpenOrders);null==a||a.step("Initialize database transaction");const o=await db_1.sequelize.transaction();try{null==a||a.step("Fetch active markets and bots");const e=await db_1.models.aiMarketMaker.findAll({where:{status:"ACTIVE"},include:[{model:db_1.models.aiMarketMakerPool,as:"pool"}],transaction:o}),t=await db_1.models.aiBot.count({where:{status:"ACTIVE"},transaction:o});null==a||a.step("Stop all markets and bots");await db_1.models.aiMarketMaker.update({status:"STOPPED"},{where:{},transaction:o});await db_1.models.aiBot.update({status:"PAUSED"},{where:{},transaction:o});null==a||a.step("Update global settings");const n=cache_1.CacheManager.getInstance();await n.updateSetting("aiMarketMakerGlobalPauseEnabled",!0);await n.updateSetting("aiMarketMakerEnabled",!1);null==a||a.step("Create history records for all markets");if(e.length>0){const t=e.map(e=>{const t=e.pool;return{marketMakerId:e.id,action:"EMERGENCY_STOP",details:{reason:r,previousStatus:e.status,triggeredBy:"admin",cancelledOrders:s},priceAtAction:e.targetPrice,poolValueAtAction:(null==t?void 0:t.totalValueLocked)||0}});await db_1.models.aiMarketMakerHistory.bulkCreate(t,{transaction:o})}null==a||a.step("Cancel all open orders");let i=0;if(s){const e=await db_1.models.aiMarketMaker.findAll({include:[{model:db_1.models.ecosystemMarket,as:"market"}],transaction:o});for(const t of e){const e=t.market;if(e){const a=`${e.currency}/${e.pair}`;try{const e=await(0,queries_1.getOpenBotEcosystemOrderIds)(a);if(e.length>0){const t=await matchingEngine_1.MatchingEngine.getInstance(),r=await Promise.allSettled(e.map(e=>t.handleOrderCancellation(e,a)));for(const e of r)"fulfilled"===e.status?i++:console_1.logger.warn("AI_MM","Failed to cancel order",e.reason)}await(0,queries_1.deleteAiBotOrdersByMarket)(t.marketId);console_1.logger.info("AI_MM",`Cleaned up orders for ${a}`)}catch(e){console_1.logger.error("AI_MM",`Error cleaning up ${a}`,e)}}}}null==a||a.step("Commit transaction");await o.commit();null==a||a.success("Emergency stop executed successfully");return{message:"Emergency stop executed successfully",marketsStopped:e.length,botsStopped:t,ordersCancelled:i,reason:r,timestamp:(new Date).toISOString(),warning:"All AI market maker operations have been stopped. Manual intervention required to resume."}}catch(e){await o.rollback();throw e}};