"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),utils_1=require("../utils"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize");exports.metadata={summary:"Get global AI Market Maker analytics overview",operationId:"getAiMarketMakerAnalyticsOverview",tags:["Admin","AI Market Maker","Analytics"],responses:{200:{description:"Global analytics overview",content:{"application/json":{schema:utils_1.analyticsOverviewSchema}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_AI",logTitle:"Get Market Maker Overview",permission:"view.ai.market-maker.analytics"};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Get Market Maker Overview");const a=await db_1.models.aiMarketMaker.findAll({include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"}]}),r=await db_1.models.aiBot.findAll();let l=0,s=0,i=0,o=0;for(const e of a){const t=e.pool;if(t){l+=Number(t.totalValueLocked)||0;s+=(Number(t.unrealizedPnL)||0)+(Number(t.realizedPnL)||0)}if("ACTIVE"===e.status){o++;i+=Number(e.currentDailyVolume)||0}}const u=r.length,n=r.filter(e=>"ACTIVE"===e.status).length,d=new Date(Date.now()-864e5),c=await db_1.models.aiMarketMakerHistory.count({where:{createdAt:{[sequelize_1.Op.gte]:d},action:"TRADE"}}),m={active:a.filter(e=>"ACTIVE"===e.status).length,paused:a.filter(e=>"PAUSED"===e.status).length,stopped:a.filter(e=>"STOPPED"===e.status).length},k=a.map(e=>({id:e.id,status:e.status,targetPrice:e.targetPrice||0,currentDailyVolume:e.currentDailyVolume||0,updatedAt:e.updatedAt,activeBots:r.filter(t=>t.marketMakerId===e.id&&"ACTIVE"===t.status).length,pool:e.pool?{totalValueLocked:e.pool.totalValueLocked||0,realizedPnL:e.pool.realizedPnL||0,unrealizedPnL:e.pool.unrealizedPnL||0}:null,market:e.market?{id:e.market.id,symbol:`${e.market.currency}/${e.market.pair}`,currency:e.market.currency,pair:e.market.pair}:null}));null==t||t.success("Get Market Maker Overview retrieved successfully");return{totalTVL:l,total24hVolume:i,totalPnL:s,pnlPercent:l>0?s/l*100:0,activeMarkets:o,totalMarkets:a.length,totalBots:u,activeBots:n,recentTradeCount:c,marketsByStatus:m,markets:k,lastUpdated:(new Date).toISOString()}};