"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),db_1=require("@b/db"),errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error");exports.metadata={summary:"Create a new affiliate reward",operationId:"createAffiliateReward",tags:["Admin","Affiliate","Reward"],description:"Creates a new affiliate referral reward for a specific referrer and condition. Validates that the referrer exists before creating the reward.",requestBody:{required:!0,content:{"application/json":{schema:utils_1.mlmReferralRewardUpdateSchema}}},responses:{200:utils_1.mlmReferralRewardStoreSchema,400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Referrer"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"create.affiliate.reward",logModule:"ADMIN_AFFILIATE",logTitle:"Create affiliate reward"};exports.default=async e=>{const{body:r,ctx:a}=e,{reward:t,isClaimed:s,conditionId:i,referrerId:o}=r;null==a||a.step("Verifying referrer exists");if(!await db_1.models.user.findOne({where:{id:o}}))throw(0,error_1.createError)({statusCode:404,message:"Referrer not found"});null==a||a.step("Creating reward record");const d=await(0,query_1.storeRecord)({model:"mlmReferralReward",data:{reward:t,isClaimed:s,conditionId:i,referrerId:o}});null==a||a.success("Reward created successfully");return d};