"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk delete affiliate rewards",operationId:"bulkDeleteAffiliateRewards",tags:["Admin","Affiliate","Reward"],description:"Deletes multiple affiliate referral rewards by their IDs. This operation permanently removes the rewards from the system.",parameters:(0,query_1.commonBulkDeleteParams)("Affiliate Rewards"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of affiliate reward IDs to delete"}},required:["ids"]}}}},responses:{200:{description:"Affiliate rewards deleted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"delete.affiliate.reward",logModule:"ADMIN_AFFILIATE",logTitle:"Bulk delete affiliate rewards"};exports.default=async e=>{const{body:r,query:s,ctx:t}=e,{ids:a}=r;null==t||t.step(`Bulk deleting ${a.length} rewards`);const i=(0,query_1.handleBulkDelete)({model:"mlmReferralReward",ids:a,query:s});null==t||t.success("Bulk delete completed successfully");return i};