"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk updates affiliate referral status",description:"Updates the status of multiple affiliate referrals at once. Valid statuses are PENDING, ACTIVE, and REJECTED. This operation affects the referral eligibility for rewards and commissions.",operationId:"bulkUpdateAffiliateReferralStatus",tags:["Admin","Affiliate","Referral"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of affiliate referral IDs to update",items:{type:"string",format:"uuid"}},status:{type:"string",enum:["PENDING","ACTIVE","REJECTED"],description:"New status to apply to the affiliate referrals"}},required:["ids","status"]}}}},responses:{200:{description:"Affiliate referral status updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Affiliate Referral"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"edit.affiliate.referral",logModule:"ADMIN_AFFILIATE",logTitle:"Bulk update affiliate referral status"};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:r,status:a}=t;null==s||s.step(`Bulk updating status for ${r.length} referrals`);const i=(0,query_1.updateStatus)("mlmReferral",r,a);null==s||s.success("Bulk status update completed successfully");return i};