"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),db_1=require("@b/db"),utils_2=require("@b/api/(ext)/affiliate/utils"),affiliate_1=require("@b/utils/affiliate"),errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error");exports.metadata={summary:"Creates a new affiliate referral",description:"Creates a new affiliate referral relationship between two users. Automatically creates the appropriate MLM node structure (binary/unilevel) based on the system configuration. For DIRECT systems, only the referral record is created without node structures.",operationId:"createAffiliateReferral",tags:["Admin","Affiliate","Referral"],requestBody:{required:!0,content:{"application/json":{schema:utils_1.mlmReferralUpdateSchema}}},responses:{200:{description:"Affiliate referral created successfully",content:{"application/json":{schema:{type:"object",properties:utils_1.mlmReferralStoreSchema}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,409:(0,errors_1.conflictResponse)("Referral"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"create.affiliate.referral",logModule:"ADMIN_AFFILIATE",logTitle:"Create affiliate referral"};exports.default=async e=>{const{body:r,ctx:t}=e,{status:s,referrerId:a,referredId:i}=r;null==t||t.step("Validating referral data");if(a===i)throw(0,error_1.createError)({statusCode:400,message:"Referrer and referred user cannot be the same"});null==t||t.step("Verifying referrer user");if(!await db_1.models.user.findOne({where:{id:a}}))throw(0,error_1.createError)({statusCode:404,message:"Referrer not found"});null==t||t.step("Verifying referred user");if(!await db_1.models.user.findOne({where:{id:i}}))throw(0,error_1.createError)({statusCode:404,message:"Referred user not found"});null==t||t.step("Creating referral record");const l=await(0,query_1.storeRecord)({model:"mlmReferral",data:{status:s,referrerId:a,referredId:i}});null==t||t.step("Fetching MLM system settings");const{mlmSystem:o}=await(0,utils_2.getMlmSystemAndSettings)();if("DIRECT"===o){null==t||t.success("Referral created successfully (DIRECT system)");return l}if("BINARY"===o){null==t||t.step("Creating binary node structure");await(0,affiliate_1.handleBinaryMlmReferralRegister)(a,l,db_1.models.mlmBinaryNode)}else if("UNILEVEL"===o){null==t||t.step("Creating unilevel node structure");await(0,affiliate_1.handleUnilevelMlmReferralRegister)(a,l,db_1.models.mlmUnilevelNode)}null==t||t.success("Referral created successfully");return l};