"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class kycVerificationResult extends sequelize_1.Model{static initModel(e){return kycVerificationResult.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the verification result"},applicationId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"applicationId: Application ID cannot be null"}},comment:"ID of the KYC application this result belongs to"},serviceId:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"serviceId: Service ID cannot be empty"}},comment:"ID of the verification service that generated this result"},status:{type:sequelize_1.DataTypes.ENUM("VERIFIED","FAILED","PENDING","NOT_STARTED"),allowNull:!1,validate:{isIn:{args:[["VERIFIED","FAILED","PENDING","NOT_STARTED"]],msg:"status: Invalid status value"}},comment:"Status of the verification process for this service"},score:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,validate:{isFloat:{msg:"score: Must be a valid number"},min:{args:[0],msg:"score: Cannot be negative"}},comment:"Verification confidence score provided by the service"},checks:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"Detailed verification checks and their results"},documentVerifications:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"Results of document verification checks"}},{sequelize:e,modelName:"kycVerificationResult",tableName:"kyc_verification_result",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]}]})}static associate(e){kycVerificationResult.belongsTo(e.kycApplication,{as:"application",foreignKey:"applicationId",onDelete:"CASCADE",onUpdate:"CASCADE"});kycVerificationResult.belongsTo(e.kycVerificationService,{as:"service",foreignKey:"serviceId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=kycVerificationResult;