"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize"),redis_1=require("@b/utils/redis"),console_1=require("@b/utils/console");class kycLevel extends sequelize_1.Model{static initModel(e){return kycLevel.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the KYC verification level"},serviceId:{type:sequelize_1.DataTypes.STRING,allowNull:!0,comment:"ID of the external verification service used for this level"},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Name cannot be empty"}},comment:"Name of the KYC level (e.g., 'Basic', 'Intermediate', 'Advanced')"},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Detailed description of the KYC level requirements"},level:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"level: Level must be an integer"}},comment:"Numeric level indicating the verification tier (1, 2, 3, etc.)"},fields:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"Required fields and documents for this KYC level"},features:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"Features and benefits unlocked at this KYC level"},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","DRAFT","INACTIVE"),allowNull:!1,defaultValue:"ACTIVE",validate:{isIn:{args:[["ACTIVE","DRAFT","INACTIVE"]],msg:"status: Status must be either ACTIVE, DRAFT, or INACTIVE"}},comment:"Current status of this KYC level configuration"}},{sequelize:e,modelName:"kycLevel",tableName:"kyc_level",timestamps:!0,paranoid:!1,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]}],hooks:{afterUpdate:async t=>{try{const l=redis_1.RedisSingleton.getInstance(),i=await e.models.kycApplication.findAll({where:{levelId:t.id,status:"APPROVED"},attributes:["userId"]});for(const e of i){const t=e.get({plain:!0});await l.del(`user:${t.userId}:profile`)}}catch(e){console_1.logger.error("KYC","Error clearing user caches after KYC level update",e)}},afterBulkUpdate:async t=>{try{const l=redis_1.RedisSingleton.getInstance(),i=await kycLevel.findAll({where:t.where,attributes:["id"]});for(const t of i){const i=await e.models.kycApplication.findAll({where:{levelId:t.id,status:"APPROVED"},attributes:["userId"]});for(const e of i){const t=e.get({plain:!0});await l.del(`user:${t.userId}:profile`)}}}catch(e){console_1.logger.error("KYC","Error clearing user caches after bulk KYC level update",e)}}}})}static associate(e){kycLevel.hasMany(e.kycApplication,{as:"applications",foreignKey:"levelId",onDelete:"CASCADE",onUpdate:"CASCADE"});kycLevel.belongsTo(e.kycVerificationService,{as:"verificationService",foreignKey:"serviceId",onDelete:"SET NULL",onUpdate:"CASCADE"})}}exports.default=kycLevel;