"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class investmentDuration extends sequelize_1.Model{static initModel(e){return investmentDuration.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the investment duration option"},duration:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"duration: Duration must be an integer"}},comment:"Duration value (number of timeframe units)"},timeframe:{type:sequelize_1.DataTypes.ENUM("HOUR","DAY","WEEK","MONTH"),allowNull:!1,validate:{isIn:{args:[["HOUR","DAY","WEEK","MONTH"]],msg:"timeframe: Timeframe must be one of HOUR, DAY, WEEK, MONTH"}},comment:"Time unit for the duration (HOUR, DAY, WEEK, MONTH)"}},{sequelize:e,modelName:"investmentDuration",tableName:"investment_duration",timestamps:!1,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]}]})}static associate(e){investmentDuration.hasMany(e.investment,{as:"investments",foreignKey:"durationId",onDelete:"CASCADE",onUpdate:"CASCADE"});investmentDuration.hasMany(e.investmentPlanDuration,{as:"investmentPlanDurations",foreignKey:"durationId",onDelete:"CASCADE",onUpdate:"CASCADE"});investmentDuration.belongsToMany(e.investmentPlan,{through:e.investmentPlanDuration,as:"plans",foreignKey:"durationId",otherKey:"planId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=investmentDuration;