"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class investment extends sequelize_1.Model{static initModel(e){return investment.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the investment record"},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}},comment:"ID of the user who made this investment"},planId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"planId: Plan ID must be a valid UUID"}},comment:"ID of the investment plan being invested in"},durationId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"durationId: Duration ID must be a valid UUID"}},comment:"ID of the duration period for this investment"},amount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"amount: Amount must be a number"}},comment:"Amount invested by the user"},profit:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,validate:{isFloat:{msg:"profit: Profit must be a number"}},comment:"Profit earned from this investment (if completed)"},result:{type:sequelize_1.DataTypes.ENUM("WIN","LOSS","DRAW"),allowNull:!0,validate:{isIn:{args:[["WIN","LOSS","DRAW"]],msg:"result: Result must be WIN, LOSS, or DRAW"}},comment:"Final result of the investment (WIN, LOSS, or DRAW)"},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","COMPLETED","CANCELLED","REJECTED"),allowNull:!1,defaultValue:"ACTIVE",validate:{isIn:{args:[["ACTIVE","COMPLETED","CANCELLED","REJECTED"]],msg:"status: Status must be ACTIVE, COMPLETED, CANCELLED, or REJECTED"}},comment:"Current status of the investment"},endDate:{type:sequelize_1.DataTypes.DATE(3),allowNull:!0,comment:"Date when the investment period ends"}},{sequelize:e,modelName:"investment",tableName:"investment",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"investmentIdKey",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"investmentUserIdFkey",using:"BTREE",fields:[{name:"userId"}]},{name:"investmentPlanIdFkey",using:"BTREE",fields:[{name:"planId"}]},{name:"investmentDurationIdFkey",using:"BTREE",fields:[{name:"durationId"}]},{name:"investmentUserIdPlanIdStatusUnique",unique:!0,using:"BTREE",fields:["userId","planId","status"],where:{status:"ACTIVE"}}]})}static associate(e){investment.belongsTo(e.investmentPlan,{as:"plan",foreignKey:"planId",onDelete:"CASCADE",onUpdate:"CASCADE"});investment.belongsTo(e.investmentDuration,{as:"duration",foreignKey:"durationId",onDelete:"CASCADE",onUpdate:"CASCADE"});investment.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=investment;