"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class transaction extends sequelize_1.Model{static initModel(e){return transaction.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}},comment:"ID of the user associated with this transaction"},walletId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"walletId: Wallet ID cannot be null"}},comment:"ID of the wallet involved in this transaction"},type:{type:sequelize_1.DataTypes.ENUM("FAILED","DEPOSIT","WITHDRAW","OUTGOING_TRANSFER","INCOMING_TRANSFER","PAYMENT","REFUND","BINARY_ORDER","EXCHANGE_ORDER","INVESTMENT","INVESTMENT_ROI","AI_INVESTMENT","AI_INVESTMENT_ROI","INVOICE","FOREX_DEPOSIT","FOREX_WITHDRAW","FOREX_INVESTMENT","FOREX_INVESTMENT_ROI","ICO_CONTRIBUTION","REFERRAL_REWARD","STAKING","STAKING_REWARD","P2P_OFFER_TRANSFER","P2P_TRADE","NFT_PURCHASE","NFT_SALE","NFT_MINT","NFT_BURN","NFT_TRANSFER","NFT_AUCTION_BID","NFT_AUCTION_SETTLE","NFT_OFFER"),allowNull:!1,validate:{isIn:{args:[["FAILED","DEPOSIT","WITHDRAW","OUTGOING_TRANSFER","INCOMING_TRANSFER","PAYMENT","REFUND","BINARY_ORDER","EXCHANGE_ORDER","INVESTMENT","INVESTMENT_ROI","AI_INVESTMENT","AI_INVESTMENT_ROI","INVOICE","FOREX_DEPOSIT","FOREX_WITHDRAW","FOREX_INVESTMENT","FOREX_INVESTMENT_ROI","ICO_CONTRIBUTION","REFERRAL_REWARD","STAKING","STAKING_REWARD","P2P_OFFER_TRANSFER","P2P_TRADE","NFT_PURCHASE","NFT_SALE","NFT_MINT","NFT_BURN","NFT_TRANSFER","NFT_AUCTION_BID","NFT_AUCTION_SETTLE","NFT_OFFER"]],msg:"type: Type must be one of the valid transaction types"}},comment:"Type of transaction (deposit, withdrawal, transfer, trading, NFT, etc.)"},status:{type:sequelize_1.DataTypes.ENUM("PENDING","COMPLETED","FAILED","CANCELLED","EXPIRED","REJECTED","REFUNDED","FROZEN","PROCESSING","TIMEOUT"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","COMPLETED","FAILED","CANCELLED","EXPIRED","REJECTED","REFUNDED","FROZEN","PROCESSING","TIMEOUT"]],msg:"status: Status must be one of ['PENDING', 'COMPLETED', 'FAILED', 'CANCELLED', 'EXPIRED', 'REJECTED', 'REFUNDED','FROZEN', 'PROCESSING', 'TIMEOUT']"}},comment:"Current status of the transaction"},amount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"amount: Amount must be a number"}},comment:"Transaction amount in the wallet's currency"},fee:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,defaultValue:0,comment:"Fee charged for this transaction"},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Human-readable description of the transaction"},metadata:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Additional transaction data in JSON format"},referenceId:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,unique:"transactionReferenceIdKey",comment:"External reference ID from payment processor or exchange"},trxId:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,comment:"Blockchain transaction hash or ID"}},{sequelize:e,modelName:"transaction",tableName:"transaction",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"transactionIdKey",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"transactionReferenceIdKey",unique:!0,using:"BTREE",fields:[{name:"referenceId"}]},{name:"transactionWalletIdForeign",using:"BTREE",fields:[{name:"walletId"}]},{name:"transactionUserIdFkey",using:"BTREE",fields:[{name:"userId"}]}]})}static associate(e){transaction.hasOne(e.adminProfit,{as:"adminProfit",foreignKey:"transactionId",onDelete:"CASCADE",onUpdate:"CASCADE"});transaction.belongsTo(e.wallet,{as:"wallet",foreignKey:"walletId",onDelete:"CASCADE",onUpdate:"CASCADE"});transaction.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=transaction;