"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const lodash_1=require("lodash"),sequelize_1=require("sequelize");class depositMethod extends sequelize_1.Model{static initModel(e){return depositMethod.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},title:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"title: Title must not be empty"}},comment:"Display name of the deposit method"},instructions:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"instructions: Instructions must not be empty"}},comment:"Step-by-step instructions for using this deposit method"},image:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0,validate:{is:{args:["^/(uploads|img)/.*$","i"],msg:"image: Image must be a valid URL"}},comment:"URL path to the method's logo or icon"},fixedFee:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"fixedFee: Fixed fee must be a valid number"},min:{args:[0],msg:"fixedFee: Fixed fee cannot be negative"}},comment:"Fixed fee amount charged for deposits"},percentageFee:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"percentageFee: Percentage fee must be a valid number"},min:{args:[0],msg:"percentageFee: Percentage fee cannot be negative"}},comment:"Percentage fee charged on deposit amount"},minAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"minAmount: Minimum amount must be a valid number"},min:{args:[0],msg:"minAmount: Minimum amount cannot be negative"}},comment:"Minimum deposit amount allowed"},maxAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"maxAmount: Maximum amount must be a valid number"},min:{args:[0],msg:"maxAmount: Maximum amount cannot be negative"}},comment:"Maximum deposit amount allowed"},customFields:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("customFields");return e?JSON.parse(e):null},set(e){this.setDataValue("customFields",JSON.stringify(e.filter(e=>e.title&&""!==e.title).map(e=>({name:(0,lodash_1.camelCase)(e.title.trim()),title:e.title.trim(),type:e.type,required:e.required}))))},comment:"Custom form fields required for this deposit method"},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!0,defaultValue:!0,comment:"Whether this deposit method is active and available"}},{sequelize:e,modelName:"depositMethod",tableName:"deposit_method",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]}]})}static associate(e){}}exports.default=depositMethod;