"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class p2pTrade extends sequelize_1.Model{static initModel(e){return p2pTrade.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},offerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"offerId cannot be null"},isUUID:{args:4,msg:"offerId must be a valid UUID"}}},buyerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"buyerId cannot be null"},isUUID:{args:4,msg:"buyerId must be a valid UUID"}}},sellerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"sellerId cannot be null"},isUUID:{args:4,msg:"sellerId must be a valid UUID"}}},type:{type:sequelize_1.DataTypes.ENUM("BUY","SELL"),allowNull:!1,validate:{isIn:{args:[["BUY","SELL"]],msg:"type must be BUY or SELL"}}},currency:{type:sequelize_1.DataTypes.STRING(50),allowNull:!1,validate:{notEmpty:{msg:"currency must not be empty"}}},amount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"amount must be a valid number"},min:{args:[0],msg:"amount cannot be negative"}}},price:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"price must be a valid number"},min:{args:[0],msg:"price cannot be negative"}}},total:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"total must be a valid number"},min:{args:[0],msg:"total cannot be negative"}}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","PAYMENT_SENT","COMPLETED","CANCELLED","DISPUTED","EXPIRED"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","PAYMENT_SENT","COMPLETED","CANCELLED","DISPUTED","EXPIRED"]],msg:"Invalid status"}}},paymentMethod:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"paymentMethod cannot be null"},isUUID:{args:4,msg:"paymentMethod must be a valid UUID"}}},paymentDetails:{type:sequelize_1.DataTypes.JSON,allowNull:!0},timeline:{type:sequelize_1.DataTypes.JSON,allowNull:!0},terms:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},escrowFee:{type:sequelize_1.DataTypes.STRING(50),allowNull:!0},buyerFee:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,defaultValue:0},sellerFee:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,defaultValue:0},escrowTime:{type:sequelize_1.DataTypes.STRING(50),allowNull:!0},paymentConfirmedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},paymentReference:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0}},{sequelize:e,modelName:"p2pTrade",tableName:"p2p_trades",timestamps:!0,paranoid:!0})}static associate(e){p2pTrade.belongsTo(e.user,{as:"buyer",foreignKey:"buyerId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pTrade.belongsTo(e.user,{as:"seller",foreignKey:"sellerId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pTrade.belongsTo(e.p2pOffer,{as:"offer",foreignKey:"offerId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pTrade.hasOne(e.p2pDispute,{as:"dispute",foreignKey:"tradeId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pTrade.hasMany(e.p2pReview,{as:"reviews",foreignKey:"tradeId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pTrade.belongsTo(e.p2pPaymentMethod,{as:"paymentMethodDetails",foreignKey:"paymentMethod",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=p2pTrade;