"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class p2pPaymentMethod extends sequelize_1.Model{static initModel(e){return p2pPaymentMethod.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"buyerId must be a valid UUID"}}},name:{type:sequelize_1.DataTypes.STRING(100),allowNull:!1,validate:{notEmpty:{msg:"Payment method name must not be empty"}}},icon:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"Icon URL must not be empty"}}},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},instructions:{type:sequelize_1.DataTypes.TEXT("long"),allowNull:!0},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"Flexible key-value pairs for payment details (e.g., PayPal Email, Bank Account, etc.)",get(){const e=this.getDataValue("metadata");if(!e)return null;if("string"==typeof e)try{return JSON.parse(e)}catch(e){return null}return e}},processingTime:{type:sequelize_1.DataTypes.STRING(50),allowNull:!0},fees:{type:sequelize_1.DataTypes.STRING(50),allowNull:!0},available:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},isGlobal:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1,comment:"If true, this payment method is available to all users (created by admin)"},popularityRank:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0}},{sequelize:e,modelName:"p2pPaymentMethod",tableName:"p2p_payment_methods",timestamps:!0,paranoid:!0})}static associate(e){p2pPaymentMethod.belongsToMany(e.p2pOffer,{through:"p2p_offer_payment_method",as:"offers",foreignKey:"paymentMethodId",otherKey:"offerId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pPaymentMethod.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=p2pPaymentMethod;