"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class p2pOffer extends sequelize_1.Model{static initModel(e){return p2pOffer.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"userId must be a valid UUID"}}},type:{type:sequelize_1.DataTypes.ENUM("BUY","SELL"),allowNull:!1,validate:{isIn:{args:[["BUY","SELL"]],msg:"Invalid trade type"}}},currency:{type:sequelize_1.DataTypes.STRING(50),allowNull:!1,validate:{notEmpty:{msg:"currency must not be empty"}}},walletType:{type:sequelize_1.DataTypes.ENUM("FIAT","SPOT","ECO"),allowNull:!1,validate:{isIn:{args:[["FIAT","SPOT","ECO"]],msg:"Invalid wallet type"}}},priceCurrency:{type:sequelize_1.DataTypes.STRING(10),allowNull:!0,comment:"Currency used for pricing (USD, EUR, GBP, etc.)"},amountConfig:{type:sequelize_1.DataTypes.JSON,allowNull:!1,get(){const e=this.getDataValue("amountConfig");if("string"==typeof e)try{return JSON.parse(e)}catch(e){return{}}return e||{}},set(e){if("string"==typeof e)try{JSON.parse(e);this.setDataValue("amountConfig",e)}catch(e){this.setDataValue("amountConfig",JSON.stringify({}))}else"object"==typeof e&&null!==e?this.setDataValue("amountConfig",JSON.stringify(e)):this.setDataValue("amountConfig",JSON.stringify({}))}},priceConfig:{type:sequelize_1.DataTypes.JSON,allowNull:!1,get(){const e=this.getDataValue("priceConfig");if("string"==typeof e)try{return JSON.parse(e)}catch(e){return{}}return e||{}},set(e){if("string"==typeof e)try{JSON.parse(e);this.setDataValue("priceConfig",e)}catch(e){this.setDataValue("priceConfig",JSON.stringify({}))}else"object"==typeof e&&null!==e?this.setDataValue("priceConfig",JSON.stringify(e)):this.setDataValue("priceConfig",JSON.stringify({}))}},tradeSettings:{type:sequelize_1.DataTypes.JSON,allowNull:!1,get(){const e=this.getDataValue("tradeSettings");if("string"==typeof e)try{return JSON.parse(e)}catch(e){return{}}return e||{}},set(e){if("string"==typeof e)try{JSON.parse(e);this.setDataValue("tradeSettings",e)}catch(e){this.setDataValue("tradeSettings",JSON.stringify({}))}else"object"==typeof e&&null!==e?this.setDataValue("tradeSettings",JSON.stringify(e)):this.setDataValue("tradeSettings",JSON.stringify({}))}},locationSettings:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("locationSettings");if(null===e)return null;if("string"==typeof e)try{return JSON.parse(e)}catch(e){return null}return e},set(e){if(null==e)this.setDataValue("locationSettings",null);else if("string"==typeof e)try{JSON.parse(e);this.setDataValue("locationSettings",e)}catch(e){this.setDataValue("locationSettings",null)}else"object"==typeof e?this.setDataValue("locationSettings",JSON.stringify(e)):this.setDataValue("locationSettings",null)}},userRequirements:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("userRequirements");if(null===e)return null;if("string"==typeof e)try{return JSON.parse(e)}catch(e){return null}return e},set(e){if(null==e)this.setDataValue("userRequirements",null);else if("string"==typeof e)try{JSON.parse(e);this.setDataValue("userRequirements",e)}catch(e){this.setDataValue("userRequirements",null)}else"object"==typeof e?this.setDataValue("userRequirements",JSON.stringify(e)):this.setDataValue("userRequirements",null)}},status:{type:sequelize_1.DataTypes.ENUM("DRAFT","PENDING_APPROVAL","ACTIVE","PAUSED","COMPLETED","CANCELLED","REJECTED","EXPIRED"),allowNull:!1,defaultValue:"DRAFT"},views:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0},systemTags:{type:sequelize_1.DataTypes.JSON,allowNull:!0},adminNotes:{type:sequelize_1.DataTypes.TEXT,allowNull:!0}},{sequelize:e,modelName:"p2pOffer",tableName:"p2p_offers",timestamps:!0,paranoid:!0})}static associate(e){p2pOffer.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pOffer.belongsToMany(e.p2pPaymentMethod,{through:"p2p_offer_payment_method",as:"paymentMethods",foreignKey:"offerId",otherKey:"paymentMethodId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pOffer.hasOne(e.p2pOfferFlag,{as:"flag",foreignKey:"offerId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pOffer.hasMany(e.p2pTrade,{as:"trades",foreignKey:"offerId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=p2pOffer;