"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class p2pDispute extends sequelize_1.Model{static initModel(e){return p2pDispute.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},tradeId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"tradeId is required"},isUUID:{args:4,msg:"tradeId must be a valid UUID"}}},amount:{type:sequelize_1.DataTypes.STRING(50),allowNull:!1,validate:{notEmpty:{msg:"amount must not be empty"}}},reportedById:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"reportedById is required"},isUUID:{args:4,msg:"reportedById must be a valid UUID"}}},againstId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"againstId is required"},isUUID:{args:4,msg:"againstId must be a valid UUID"}}},reason:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"reason must not be empty"}}},details:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},filedOn:{type:sequelize_1.DataTypes.DATE,allowNull:!1,validate:{isDate:{args:!0,msg:"filedOn must be a valid date"}}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","IN_PROGRESS","RESOLVED"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","IN_PROGRESS","RESOLVED"]],msg:"Invalid dispute status"}}},priority:{type:sequelize_1.DataTypes.ENUM("HIGH","MEDIUM","LOW"),allowNull:!1,validate:{isIn:{args:[["HIGH","MEDIUM","LOW"]],msg:"Invalid priority"}}},resolution:{type:sequelize_1.DataTypes.JSON,allowNull:!0},resolvedOn:{type:sequelize_1.DataTypes.DATE,allowNull:!0},messages:{type:sequelize_1.DataTypes.JSON,allowNull:!0},evidence:{type:sequelize_1.DataTypes.JSON,allowNull:!0},activityLog:{type:sequelize_1.DataTypes.JSON,allowNull:!0}},{sequelize:e,modelName:"p2pDispute",tableName:"p2p_disputes",timestamps:!0,paranoid:!0})}static associate(e){p2pDispute.belongsTo(e.p2pTrade,{as:"trade",foreignKey:"tradeId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pDispute.belongsTo(e.user,{as:"reportedBy",foreignKey:"reportedById",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pDispute.belongsTo(e.user,{as:"against",foreignKey:"againstId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=p2pDispute;