"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftSale extends sequelize_1.Model{static initModel(e){return nftSale.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"tokenId: Token ID cannot be null"},isUUID:{args:4,msg:"tokenId: Token ID must be a valid UUID"}}},listingId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"listingId: Listing ID must be a valid UUID"}}},sellerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"sellerId: Seller ID cannot be null"},isUUID:{args:4,msg:"sellerId: Seller ID must be a valid UUID"}}},buyerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"buyerId: Buyer ID cannot be null"},isUUID:{args:4,msg:"buyerId: Buyer ID must be a valid UUID"}}},price:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,validate:{min:{args:[0],msg:"price: Price must be positive"}}},currency:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,defaultValue:"ETH",validate:{notEmpty:{msg:"currency: Currency must not be empty"}}},marketplaceFee:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,defaultValue:0,validate:{min:{args:[0],msg:"marketplaceFee: Marketplace fee must be non-negative"}}},royaltyFee:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,defaultValue:0,validate:{min:{args:[0],msg:"royaltyFee: Royalty fee must be non-negative"}}},totalFee:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,defaultValue:0,validate:{min:{args:[0],msg:"totalFee: Total fee must be non-negative"}}},netAmount:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,validate:{min:{args:[0],msg:"netAmount: Net amount must be non-negative"}}},transactionHash:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{is:{args:/^0x[a-fA-F0-9]{64}$/,msg:"transactionHash: Invalid transaction hash format"}}},blockNumber:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,validate:{min:{args:[0],msg:"blockNumber: Block number must be non-negative"}}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","COMPLETED","FAILED","CANCELLED"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","COMPLETED","FAILED","CANCELLED"]],msg:"status: Status must be one of 'PENDING', 'COMPLETED', 'FAILED', or 'CANCELLED'"}}},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return e?JSON.parse(e):null},set(e){this.setDataValue("metadata",JSON.stringify(e))}}},{sequelize:e,modelName:"nftSale",tableName:"nft_sale",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"nftSaleTokenIdx",using:"BTREE",fields:[{name:"tokenId"}]},{name:"nftSaleListingIdx",using:"BTREE",fields:[{name:"listingId"}]},{name:"nftSaleSellerIdx",using:"BTREE",fields:[{name:"sellerId"}]},{name:"nftSaleBuyerIdx",using:"BTREE",fields:[{name:"buyerId"}]},{name:"nftSaleStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"nftSalePriceIdx",using:"BTREE",fields:[{name:"price"}]},{name:"nftSaleCreatedAtIdx",using:"BTREE",fields:[{name:"createdAt"}]}]})}static associate(e){nftSale.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftSale.belongsTo(e.nftListing,{as:"listing",foreignKey:"listingId",onDelete:"SET NULL",onUpdate:"CASCADE"});nftSale.belongsTo(e.user,{as:"seller",foreignKey:"sellerId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftSale.belongsTo(e.user,{as:"buyer",foreignKey:"buyerId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=nftSale;