"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftOffer extends sequelize_1.Model{static initModel(e){return nftOffer.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"tokenId: Token ID must be a valid UUID"}}},collectionId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"collectionId: Collection ID must be a valid UUID"}}},listingId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"listingId: Listing ID must be a valid UUID"}}},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},amount:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,validate:{min:{args:[0],msg:"amount: Amount must be positive"}}},currency:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,defaultValue:"ETH",validate:{notEmpty:{msg:"currency: Currency must not be empty"}}},expiresAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","ACCEPTED","REJECTED","EXPIRED","CANCELLED"),allowNull:!1,defaultValue:"ACTIVE",validate:{isIn:{args:[["ACTIVE","ACCEPTED","REJECTED","EXPIRED","CANCELLED"]],msg:"status: Status must be one of 'ACTIVE', 'ACCEPTED', 'REJECTED', 'EXPIRED', or 'CANCELLED'"}}},type:{type:sequelize_1.DataTypes.ENUM("TOKEN","COLLECTION"),allowNull:!0},message:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},acceptedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},rejectedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},cancelledAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},expiredAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return e?JSON.parse(e):null},set(e){this.setDataValue("metadata",JSON.stringify(e))}}},{sequelize:e,modelName:"nftOffer",tableName:"nft_offer",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"nftOfferTokenIdx",using:"BTREE",fields:[{name:"tokenId"}]},{name:"nftOfferCollectionIdx",using:"BTREE",fields:[{name:"collectionId"}]},{name:"nftOfferListingIdx",using:"BTREE",fields:[{name:"listingId"}]},{name:"nftOfferUserIdx",using:"BTREE",fields:[{name:"userId"}]},{name:"nftOfferStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"nftOfferAmountIdx",using:"BTREE",fields:[{name:"amount"}]},{name:"nftOfferExpiresAtIdx",using:"BTREE",fields:[{name:"expiresAt"}]}]})}static associate(e){nftOffer.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftOffer.belongsTo(e.nftCollection,{as:"collection",foreignKey:"collectionId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftOffer.belongsTo(e.nftListing,{as:"listing",foreignKey:"listingId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftOffer.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=nftOffer;