"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftCategory extends sequelize_1.Model{static initModel(e){return nftCategory.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},name:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,unique:"nftCategoryNameKey",validate:{notEmpty:{msg:"name: Category name must not be empty"},len:{args:[1,255],msg:"name: Category name must be between 1 and 255 characters"}}},slug:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,unique:"nftCategorySlugKey",validate:{notEmpty:{msg:"slug: Slug must not be empty"},is:{args:/^[a-z0-9-]+$/,msg:"slug: Slug must contain only lowercase letters, numbers, and hyphens"}}},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},image:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0,validate:{is:{args:["^/(uploads|img)/.*$","i"],msg:"image: Image must be a valid URL"}}},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean value"}}}},{sequelize:e,modelName:"nftCategory",tableName:"nft_category",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"nftCategoryNameKey",unique:!0,using:"BTREE",fields:[{name:"name"}]},{name:"nftCategorySlugKey",unique:!0,using:"BTREE",fields:[{name:"slug"}]},{name:"nftCategoryStatusIdx",using:"BTREE",fields:[{name:"status"}]}]})}static associate(e){nftCategory.hasMany(e.nftCollection,{as:"collections",foreignKey:"categoryId",onDelete:"SET NULL",onUpdate:"CASCADE"})}}exports.default=nftCategory;