"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class icoTokenOfferingPhase extends sequelize_1.Model{static initModel(e){return icoTokenOfferingPhase.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},offeringId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"offeringId: Offering ID cannot be null"},isUUID:{args:4,msg:"offeringId: Offering ID must be a valid UUID"}}},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Phase name must not be empty"}}},tokenPrice:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"tokenPrice: Must be a valid number"},min:{args:[0],msg:"tokenPrice: Cannot be negative"}}},allocation:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"allocation: Must be a valid number"},min:{args:[0],msg:"allocation: Cannot be negative"}}},remaining:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"remaining: Must be a valid number"},min:{args:[0],msg:"remaining: Cannot be negative"}}},duration:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"duration: Must be an integer"},min:{args:[0],msg:"duration: Cannot be negative"}}},sequence:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{isInt:{msg:"sequence: Must be an integer"},min:{args:[0],msg:"sequence: Cannot be negative"}}},startDate:{type:sequelize_1.DataTypes.DATE,allowNull:!0},endDate:{type:sequelize_1.DataTypes.DATE,allowNull:!0}},{sequelize:e,modelName:"icoTokenOfferingPhase",tableName:"ico_token_offering_phase",timestamps:!1,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"icoTokenOfferingPhaseOfferingIdNameKey",unique:!0,fields:[{name:"offeringId"},{name:"name"}]}]})}static associate(e){icoTokenOfferingPhase.belongsTo(e.icoTokenOffering,{as:"offering",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=icoTokenOfferingPhase;