"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class icoTokenOffering extends sequelize_1.Model{static initModel(e){return icoTokenOffering.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},planId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"planId: Plan ID cannot be null"},isUUID:{args:4,msg:"planId: Plan ID must be a valid UUID"}}},typeId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"typeId: Type ID cannot be null"},isUUID:{args:4,msg:"typeId: Type ID must be a valid UUID"}}},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Name must not be empty"}}},symbol:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,validate:{notEmpty:{msg:"symbol: Symbol must not be empty"}}},icon:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"icon: Icon must not be empty"}}},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","SUCCESS","FAILED","UPCOMING","PENDING","REJECTED","DISABLED","CANCELLED"),allowNull:!1,validate:{isIn:{args:[["ACTIVE","SUCCESS","FAILED","UPCOMING","PENDING","REJECTED","DISABLED","CANCELLED"]],msg:"status: Invalid status value"}}},purchaseWalletCurrency:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,validate:{notEmpty:{msg:"purchaseWalletCurrency: Currency must not be empty"}}},purchaseWalletType:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"purchaseWalletType: Wallet type must not be empty"}}},tokenPrice:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"tokenPrice: Must be a valid number"},min:{args:[0],msg:"tokenPrice: Cannot be negative"}}},targetAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"targetAmount: Must be a valid number"},min:{args:[0],msg:"targetAmount: Cannot be negative"}}},startDate:{type:sequelize_1.DataTypes.DATE,allowNull:!1,validate:{isDate:{msg:"startDate: Must be a valid date",args:!0}}},endDate:{type:sequelize_1.DataTypes.DATE,allowNull:!1,validate:{isDate:{msg:"endDate: Must be a valid date",args:!0}}},participants:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"participants: Must be an integer"},min:{args:[0],msg:"participants: Cannot be negative"}}},currentPrice:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,validate:{isFloat:{msg:"currentPrice: Must be a valid number"},min:{args:[0],msg:"currentPrice: Cannot be negative"}}},priceChange:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,validate:{isFloat:{msg:"priceChange: Must be a valid number"}}},submittedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,validate:{isDate:{msg:"submittedAt: Must be a valid date",args:!0}}},approvedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,validate:{isDate:{msg:"approvedAt: Must be a valid date",args:!0}}},rejectedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,validate:{isDate:{msg:"rejectedAt: Must be a valid date",args:!0}}},reviewNotes:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},isPaused:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},isFlagged:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},featured:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!0},website:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},cancelledAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},cancelledBy:{type:sequelize_1.DataTypes.UUID,allowNull:!0},cancellationReason:{type:sequelize_1.DataTypes.TEXT,allowNull:!0}},{sequelize:e,modelName:"icoTokenOffering",tableName:"ico_token_offering",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"icoTokenOfferingSymbolKey",unique:!0,fields:[{name:"symbol"}]}]})}static associate(e){icoTokenOffering.belongsTo(e.icoLaunchPlan,{as:"plan",foreignKey:"planId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.hasMany(e.icoTokenOfferingPhase,{as:"phases",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.hasOne(e.icoTokenDetail,{as:"tokenDetail",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.hasMany(e.icoRoadmapItem,{as:"roadmapItems",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.hasMany(e.icoTeamMember,{as:"teamMembers",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.hasMany(e.icoTransaction,{as:"transactions",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.hasMany(e.icoAdminActivity,{as:"adminActivities",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.belongsTo(e.icoTokenType,{as:"type",foreignKey:"typeId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenOffering.hasMany(e.icoTokenOfferingUpdate,{as:"updates",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=icoTokenOffering;