"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize"),validator_1=__importDefault(require("validator"));class icoTeamMember extends sequelize_1.Model{static initModel(e){return icoTeamMember.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},offeringId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"offeringId: Offering ID cannot be null"},isUUID:{args:4,msg:"offeringId: Offering ID must be a valid UUID"}}},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Name must not be empty"}}},role:{type:sequelize_1.DataTypes.STRING(100),allowNull:!1,validate:{notEmpty:{msg:"role: Role must not be empty"}}},bio:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"bio: Bio must not be empty"}}},avatar:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},linkedin:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,validate:{customIsUrl(e){if(e&&!validator_1.default.isURL(e,{require_tld:!1}))throw new Error("linkedin: Must be a valid URL")}}},twitter:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,validate:{customIsUrl(e){if(e&&!validator_1.default.isURL(e,{require_tld:!1}))throw new Error("twitter: Must be a valid URL")}}},website:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,validate:{customIsUrl(e){if(e&&!validator_1.default.isURL(e,{require_tld:!1}))throw new Error("website: Must be a valid URL")}}},github:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,validate:{customIsUrl(e){if(e&&!validator_1.default.isURL(e,{require_tld:!1}))throw new Error("github: Must be a valid URL")}}}},{sequelize:e,modelName:"icoTeamMember",tableName:"ico_team_member",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]}]})}static associate(e){icoTeamMember.belongsTo(e.icoTokenOffering,{as:"offering",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=icoTeamMember;