"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class gatewayPayment extends sequelize_1.Model{static initModel(e){return gatewayPayment.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},merchantId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"merchantId: Must be a valid UUID"}}},customerId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},transactionId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},paymentIntentId:{type:sequelize_1.DataTypes.STRING(64),allowNull:!1},merchantOrderId:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0},amount:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,validate:{min:{args:[.01],msg:"amount: Must be greater than 0"}},get(){const e=this.getDataValue("amount");return e?parseFloat(e.toString()):0}},currency:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1,validate:{notEmpty:{msg:"currency: Currency must not be empty"}}},walletType:{type:sequelize_1.DataTypes.ENUM("FIAT","SPOT","ECO"),allowNull:!1,defaultValue:"FIAT"},feeAmount:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("feeAmount");return e?parseFloat(e.toString()):0}},netAmount:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:0,get(){const e=this.getDataValue("netAmount");return e?parseFloat(e.toString()):0}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","PROCESSING","COMPLETED","FAILED","CANCELLED","EXPIRED","REFUNDED","PARTIALLY_REFUNDED"),allowNull:!1,defaultValue:"PENDING"},checkoutUrl:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!1},returnUrl:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!1,validate:{isValidUrl(e){try{new URL(e)}catch(e){throw new Error("returnUrl: Must be a valid URL")}}}},cancelUrl:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0},webhookUrl:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return"string"==typeof e?JSON.parse(e):e}},lineItems:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("lineItems");return"string"==typeof e?JSON.parse(e):e}},customerEmail:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{isEmail:{msg:"customerEmail: Must be a valid email"}}},customerName:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},billingAddress:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("billingAddress");return"string"==typeof e?JSON.parse(e):e}},expiresAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1},completedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},ipAddress:{type:sequelize_1.DataTypes.STRING(45),allowNull:!0},userAgent:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},allocations:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"Array of wallet allocations used for this payment",get(){const e=this.getDataValue("allocations");return"string"==typeof e?JSON.parse(e):e}},testMode:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1}},{sequelize:e,modelName:"gatewayPayment",tableName:"gateway_payment",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"gatewayPaymentIntentIdUnique",unique:!0,using:"BTREE",fields:[{name:"paymentIntentId"}]},{name:"gatewayPaymentMerchantIdFkey",using:"BTREE",fields:[{name:"merchantId"}]},{name:"gatewayPaymentCustomerIdFkey",using:"BTREE",fields:[{name:"customerId"}]},{name:"gatewayPaymentTransactionIdFkey",using:"BTREE",fields:[{name:"transactionId"}]},{name:"gatewayPaymentStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"gatewayPaymentMerchantOrderIdx",using:"BTREE",fields:[{name:"merchantId"},{name:"merchantOrderId"}]}]})}static associate(e){gatewayPayment.belongsTo(e.gatewayMerchant,{as:"merchant",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayPayment.belongsTo(e.user,{as:"customer",foreignKey:"customerId",onDelete:"SET NULL",onUpdate:"CASCADE"});gatewayPayment.belongsTo(e.transaction,{as:"transaction",foreignKey:"transactionId",onDelete:"SET NULL",onUpdate:"CASCADE"});gatewayPayment.hasMany(e.gatewayRefund,{as:"gatewayRefunds",foreignKey:"paymentId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayPayment.hasMany(e.gatewayWebhook,{as:"gatewayWebhooks",foreignKey:"paymentId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=gatewayPayment;