"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class ecommerceShipping extends sequelize_1.Model{static initModel(e){return ecommerceShipping.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},loadId:{type:sequelize_1.DataTypes.STRING,allowNull:!1,validate:{notEmpty:{msg:"loadId: Load ID must not be empty"}}},loadStatus:{type:sequelize_1.DataTypes.ENUM("PENDING","TRANSIT","DELIVERED","CANCELLED"),allowNull:!1,validate:{isIn:{args:[["PENDING","TRANSIT","DELIVERED","CANCELLED"]],msg:"loadStatus: Must be one of PENDING, TRANSIT, DELIVERED, CANCELLED"}}},shipper:{type:sequelize_1.DataTypes.STRING,allowNull:!1,validate:{notEmpty:{msg:"shipper: Shipper must not be empty"}}},transporter:{type:sequelize_1.DataTypes.STRING,allowNull:!1,validate:{notEmpty:{msg:"transporter: Transporter must not be empty"}}},goodsType:{type:sequelize_1.DataTypes.STRING,allowNull:!1,validate:{notEmpty:{msg:"goodsType: Goods type must not be empty"}}},weight:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isNumeric:{msg:"weight: Must be a numeric value"}}},volume:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isNumeric:{msg:"volume: Must be a numeric value"}}},description:{type:sequelize_1.DataTypes.STRING,allowNull:!1,validate:{notEmpty:{msg:"description: Description must not be empty"}}},vehicle:{type:sequelize_1.DataTypes.STRING,allowNull:!1,validate:{notEmpty:{msg:"vehicle: Vehicle must not be empty"}}},cost:{type:sequelize_1.DataTypes.FLOAT,allowNull:!0,validate:{isNumeric:{msg:"cost: Must be a numeric value"}}},tax:{type:sequelize_1.DataTypes.FLOAT,allowNull:!0,validate:{isNumeric:{msg:"tax: Must be a numeric value"}}},deliveryDate:{type:sequelize_1.DataTypes.DATE,allowNull:!0}},{sequelize:e,modelName:"ecommerceShipping",tableName:"ecommerce_shipping",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]}]})}static associate(e){ecommerceShipping.hasMany(e.ecommerceOrder,{as:"ecommerceOrders",foreignKey:"shippingId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceShipping.belongsToMany(e.ecommerceProduct,{as:"products",through:e.ecommerceOrder,foreignKey:"shippingId",otherKey:"productId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=ecommerceShipping;