"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class ecommerceDiscount extends sequelize_1.Model{static initModel(e){return ecommerceDiscount.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},code:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,unique:"ecommerceDiscountCodeKey",validate:{notEmpty:{msg:"code: Code must not be empty"}}},percentage:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"percentage: Percentage must be an integer"},min:{args:[0],msg:"percentage: Percentage cannot be negative"},max:{args:[100],msg:"percentage: Percentage cannot be more than 100"}}},validUntil:{type:sequelize_1.DataTypes.DATE(3),allowNull:!1,validate:{isDate:{msg:"validUntil: Must be a valid date",args:!0},isAfter:{args:(new Date).toISOString(),msg:"validUntil: Date must be in the future"}}},productId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"productId: Product ID must be a valid UUID"}}},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean value"}}}},{sequelize:e,modelName:"ecommerceDiscount",tableName:"ecommerce_discount",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"ecommerceDiscountCodeKey",unique:!0,using:"BTREE",fields:[{name:"code"}]},{name:"ecommerceDiscountProductIdFkey",using:"BTREE",fields:[{name:"productId"}]}]})}static associate(e){ecommerceDiscount.belongsTo(e.ecommerceProduct,{as:"product",foreignKey:"productId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceDiscount.hasMany(e.ecommerceUserDiscount,{as:"ecommerceUserDiscounts",foreignKey:"discountId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=ecommerceDiscount;