"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class mlmReferralCondition extends sequelize_1.Model{static initModel(e){return mlmReferralCondition.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Name cannot be empty"}}},title:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"title: Title cannot be empty"}}},description:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"description: Description cannot be empty"}}},type:{type:sequelize_1.DataTypes.ENUM("DEPOSIT","TRADE","SPOT_TRADE","BINARY_WIN","INVESTMENT","AI_INVESTMENT","FOREX_INVESTMENT","ICO_CONTRIBUTION","STAKING","ECOMMERCE_PURCHASE","P2P_TRADE","NFT_TRADE","COPY_TRADING","FUTURES_TRADE","TOKEN_PURCHASE"),allowNull:!1,validate:{isIn:{args:[["DEPOSIT","TRADE","SPOT_TRADE","BINARY_WIN","INVESTMENT","AI_INVESTMENT","FOREX_INVESTMENT","ICO_CONTRIBUTION","STAKING","ECOMMERCE_PURCHASE","P2P_TRADE","NFT_TRADE","COPY_TRADING","FUTURES_TRADE","TOKEN_PURCHASE"]],msg:"type: Type must be a valid referral condition type"}}},reward:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"reward: Reward must be a valid number"}}},rewardType:{type:sequelize_1.DataTypes.ENUM("PERCENTAGE","FIXED"),allowNull:!1,validate:{isIn:{args:[["PERCENTAGE","FIXED"]],msg:"rewardType: Reward type must be either PERCENTAGE or FIXED"}}},rewardWalletType:{type:sequelize_1.DataTypes.ENUM("FIAT","SPOT","ECO"),allowNull:!1,validate:{isIn:{args:[["FIAT","SPOT","ECO"]],msg:"rewardWalletType: Wallet type must be one of FIAT, SPOT, ECO"}}},rewardCurrency:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"rewardCurrency: Reward currency cannot be empty"}}},rewardChain:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},image:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},minAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"minAmount: Minimum amount must be a valid number"},min:{args:[0],msg:"minAmount: Minimum amount cannot be negative"}}},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean value"}}}},{sequelize:e,modelName:"mlmReferralCondition",tableName:"mlm_referral_condition",timestamps:!1,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"mlmReferralConditionNameKey",unique:!0,using:"BTREE",fields:[{name:"name"}]}]})}static associate(e){mlmReferralCondition.hasMany(e.mlmReferralReward,{as:"referralRewards",foreignKey:"conditionId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=mlmReferralCondition;