"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,a,i){void 0===i&&(i=a);var s=Object.getOwnPropertyDescriptor(t,a);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[a]}});Object.defineProperty(e,i,s)}:function(e,t,a,i){void 0===i&&(i=a);e[i]=t[a]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[t.length]=a);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var a={};if(null!=t)for(var i=e(t),s=0;s<i.length;s++)"default"!==i[s]&&__createBinding(a,t,i[s]);__setModuleDefault(a,t);return a}}();Object.defineProperty(exports,"__esModule",{value:!0});const Sequelize=__importStar(require("sequelize")),sequelize_1=require("sequelize");class page extends sequelize_1.Model{static initModel(e){return page.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the page"},slug:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,unique:"pageSlugKey",validate:{notEmpty:{msg:"slug: Slug cannot be empty"},isSlugFormat:e=>{if(!/^[a-z0-9-_/]+$/.test(e))throw new Error("slug: Slug must contain only lowercase letters, numbers, hyphens, underscores, and forward slashes")}},comment:"URL-friendly slug for the page (used in the page URL)"},path:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,defaultValue:"",comment:"Full path/route for the page in the website structure"},title:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"title: Title cannot be empty"},len:{args:[1,255],msg:"title: Title must be between 1 and 255 characters"}},comment:"Title of the page displayed to users and in browser tabs"},content:{type:sequelize_1.DataTypes.TEXT("long"),allowNull:!1,defaultValue:"",validate:{isValidContent:function(e){if((!this.isBuilderPage||e)&&!this.isBuilderPage&&!e)throw new Error("content: Content cannot be empty for non-builder pages")}},comment:"Main content/body of the page (HTML or Markdown)"},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Brief description of the page content"},image:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"URL path to the page's featured image"},order:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,comment:"Display order for page sorting and navigation"},visits:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,comment:"Number of times this page has been visited"},status:{type:sequelize_1.DataTypes.ENUM("PUBLISHED","DRAFT"),allowNull:!1,defaultValue:"DRAFT",validate:{isIn:{args:[["PUBLISHED","DRAFT"]],msg:"status: Status must be either PUBLISHED or DRAFT"}},comment:"Publication status of the page (PUBLISHED or DRAFT)"},isHome:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1,validate:{isUniqueHome:async function(e){if(!0===e){if(this.id){const e=await page.findOne({where:{id:this.id}});if(e&&!0===e.isHome)return}const e={isHome:!0};this.id&&(e.id={[Sequelize.Op.ne]:this.id});this.constructor.options.paranoid&&(e.deletedAt=null);if(await page.findOne({where:e}))throw new Error("isHome: Only one page can be marked as home page")}}},comment:"Indicates if this page is the site's homepage (only one allowed)"},isBuilderPage:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1,comment:"Indicates if this page was created using the page builder"},template:{type:sequelize_1.DataTypes.STRING(100),allowNull:!0,comment:"Template name used for this page layout"},category:{type:sequelize_1.DataTypes.STRING(100),allowNull:!0,comment:"Category classification for organizing pages"},seoTitle:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{len:{args:[0,255],msg:"seoTitle: SEO title must be less than 255 characters"}},comment:"SEO optimized title for search engines"},seoDescription:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,validate:{len:{args:[0,500],msg:"seoDescription: SEO description must be less than 500 characters"}},comment:"SEO meta description for search engine results"},seoKeywords:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"SEO keywords for search engine optimization"},ogImage:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Open Graph image URL for social media sharing"},ogTitle:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,comment:"Open Graph title for social media sharing"},ogDescription:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Open Graph description for social media sharing"},settings:{type:sequelize_1.DataTypes.TEXT("long"),allowNull:!0,validate:{isValidJSON:e=>{if(e)try{JSON.parse(e)}catch(e){throw new Error("settings: Settings must be valid JSON")}}},comment:"JSON string containing page-level configuration settings"},customCss:{type:sequelize_1.DataTypes.TEXT("long"),allowNull:!0,comment:"Custom CSS styles specific to this page"},customJs:{type:sequelize_1.DataTypes.TEXT("long"),allowNull:!0,comment:"Custom JavaScript code specific to this page"},lastModifiedBy:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,comment:"Username or ID of the last person to modify this page"},publishedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,comment:"Date and time when the page was first published"}},{sequelize:e,modelName:"page",tableName:"page",timestamps:!0,paranoid:!0,hooks:{beforeSave:async e=>{!e.path&&e.slug&&(e.path="home"===e.slug?"/":`/${e.slug}`);"PUBLISHED"!==e.status||e.publishedAt||(e.publishedAt=new Date);!e.seoTitle&&e.title&&(e.seoTitle=e.title);!e.seoDescription&&e.description&&(e.seoDescription=e.description)}},indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"pageSlugKey",unique:!0,using:"BTREE",fields:[{name:"slug"}]},{name:"pageStatusIndex",using:"BTREE",fields:[{name:"status"}]},{name:"pageIsHomeIndex",using:"BTREE",fields:[{name:"isHome"}]},{name:"pageIsBuilderIndex",using:"BTREE",fields:[{name:"isBuilderPage"}]},{name:"pageOrderIndex",using:"BTREE",fields:[{name:"order"}]},{name:"pagePublishedAtIndex",using:"BTREE",fields:[{name:"publishedAt"}]}]})}}exports.default=page;